<?php
define('WP_INSTALLING', true);

if (file_exists('../wp-config.php')) 
	die("Die Datei 'wp-config.php' existiert bereits. Wenn du etwas in dieser Datei neu konfigurieren musst, l&#246;sche sie bitte zuerst. Du kannst jetzt auch die <a href='install.php'>Installation</a> versuchen.");

if (!file_exists('../wp-config-sample.php'))
    die('Sorry, Ich ben&#246;tige eine wp-config-sample.php Datei mit der ich arbeiten kann. Bitte lade diese Datei erneut von deiner WordPress Installation.');
$configFile = file('../wp-config-sample.php');

if (!is_writable('../')) die("Sorry, dieses Verzeichnis ist nicht beschreibbar. Du wirst entweder die Schreibrechte deines WordPress Verzeichnisses &#228;ndern oder deine wp-config.php manuell erstellen m&#252;ssen.");

$step = 0;
if(isset($_GET['step'])) $step = $_GET['step'];
header( 'Content-Type: text/html; charset=utf-8' );
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>WordPress &rsaquo; Setup Configuration File</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<style media="screen" type="text/css">
    <!--
	body {
		font-family: Georgia, "Times New Roman", Times, serif;
		margin-left: 15%;
		margin-right: 15%;
	}
	#logo {
		margin: 0;
		padding: 0;
		background-image: url(./images/wordpress-logo.png);
		background-repeat: no-repeat;
		height: 68px;
	}
	#logo a {
		display: block;
		height: 68px;
	}
	#logo a span {
		display: none;
	}
	p, li {
		line-height: 140%;
	}
    -->
	</style>
</head>
<body> 
<h1 id="logo"><a href="http://wordpress.org/"><span>WordPress</span></a></h1> 
<?php

switch($step) {
	case 0:
?> 
<p>Willkommen bei WordPress. Bevor wir anfangen k&#246;nnen, ben&#246;tigen wir ein paar Informationen &#252;ber deine Datenbank. Die folgenden Informationen solltest du parat haben:</p>
<ol> 
  <li>Name der Datenbank</li>
  <li>Benutzername der Datenbank</li>
  <li>Passwort der Datenbank</li>
  <li>Datenbank Host (<em>MySQL Serveradresse</em>)</li>
  <li>Tabellen-Pr&#228;fix (<em>Wenn du auch andere Scripte oder mehrere WordPress Installationen &#252;ber eine Datenbank laufen lassen m&#246;chtest.</em>) </li>
</ol>
<p><strong>Wenn aus irgendeinem Grund die automatische Generierung der Dateien nicht funktioniert...keine Panik! Alles was wir hier tun, ist die oben angegebene Information an die Konfigurations-Datei zu &#252;bergeben. Alternativ kannst du auch die <code>wp-config-sample.php</code> in einem Text-Editor &#246;ffnen, die ben&#246;tigte Information dort eingeben und die Datei als <code>wp-config.php</code> speichern. </strong></p>
<p>Die notwendigen Informationen hast du von deinem Provider bekommen. Wenn du sie nicht mehr hast, wirst du deinen Provider kontaktieren m&#252;ssen, bevor wir fortfahren k&#246;nnen.
<br />
<br />
Wenn alles klar ist, <a href="setup-config.php?step=1">dann kann es jetzt losgehen!</a> </p>
<?php
	break;

	case 1:
	?> 
</p> 
<form method="post" action="setup-config.php?step=2"> 
  <p>Hier musst du die Angaben zu deiner Datenbankverbindung machen. Wenn du dir nicht sicher bist, kontaktiere deinen Provider.</p>
  <table> 
    <tr> 
      <th scope="row">Name der Datenbank</th>
      <td><input name="dbname" type="text" size="45" value="wordpress" /></td>
      <td>Der Name der Datenbank unter der WordPress laufen soll. </td>
    </tr> 
    <tr> 
      <th scope="row">Benutzer Name</th>
      <td><input name="uname" type="text" size="45" value="username" /></td>
      <td>Dein MySQL-Benutzername</td>
    </tr> 
    <tr> 
      <th scope="row">Passwort</th>
      <td><input name="pwd" type="text" size="45" value="password" /></td>
      <td>...und MySQL Passwort.</td>
    </tr> 
    <tr> 
      <th scope="row">Datenbank Host</th>
      <td><input name="dbhost" type="text" size="45" value="localhost" /></td> 
      <td>mit 99%iger Wahrscheinlichkeit musst du dies nicht &#228;ndern. (<em>MySQL Serveradresse</em>)</td>
    </tr>
    <tr>
      <th scope="row">Tabellen-Pr&#228;fix</th>
      <td><input name="prefix" type="text" id="prefix" value="wp_" size="45" /></td>
      <td>Wenn du auch andere Scripte oder mehrere WordPress Installationen &#252;ber deine Datenbank laufen lassen m&#246;chtest &#228;ndere das Pr&#228;fix.</td>
    </tr> 
  </table> 
  <input name="submit" type="submit" value="absenden" />
</form> 
<?php
	break;
	
	case 2:
	$dbname  = trim($_POST['dbname']);
    $uname   = trim($_POST['uname']);
    $passwrd = trim($_POST['pwd']);
    $dbhost  = trim($_POST['dbhost']);
	$prefix  = trim($_POST['prefix']);
	if (empty($prefix)) $prefix = 'wp_';

    // Test the db connection.
    define('DB_NAME', $dbname);
    define('DB_USER', $uname);
    define('DB_PASSWORD', $passwrd);
    define('DB_HOST', $dbhost);

    // We'll fail here if the values are no good.
    require_once('../wp-includes/wp-db.php');
	$handle = fopen('../wp-config.php', 'w');

    foreach ($configFile as $line_num => $line) {
        switch (substr($line,0,16)) {
            case "define('DB_NAME'":
                fwrite($handle, str_replace("wordpress", $dbname, $line));
                break;
            case "define('DB_USER'":
                fwrite($handle, str_replace("'username'", "'$uname'", $line));
                break;
            case "define('DB_PASSW":
                fwrite($handle, str_replace("'password'", "'$passwrd'", $line));
                break;
            case "define('DB_HOST'":
                fwrite($handle, str_replace("localhost", $dbhost, $line));
                break;
			case '$table_prefix  =':
				fwrite($handle, str_replace('wp_', $prefix, $line));
				break;
            default:
                fwrite($handle, $line);
        }
    }
    fclose($handle);
	chmod('../wp-config.php', 0666);
?> 
<p>Alles klar! Du bist durch den wichtigsten Teil der Installation gekommen. WordPress kann nun mit deiner Datenbank kommunizieren. Wenn du fertig bist, <a href="install.php">starten wir die Installation!</a></p>
<?php
	break;

}
?> 
</body>
</html>



