\name{xrt.plot}
\title{Interface to 3d Plots with XRT}
\author{A. Gebhardt}
\usage{xrt.plot(x, y, z, file="xrt.dat")
}
\alias{xrt.plot}
\arguments{
  \item{x,y,z}{grid data, see e.g. \code{\link{contour}}}
  \item{file}{name for temporary file, default "xrt.dat"}
}
\description{This function provides an interface to 3d visualisation
  with programs based on XRT's 3d widget set for Motif.

  Currently it uses one of the demo programs of XRT/3d for vizualisation, 
  but it should be possible to write own 3d plot programs with the XRT
  toolkit. 

  You can even modify and save your dataset within the plot window. Use
  \code{\link{xrt.read}} to read the modified data.
}
\value{None
}
\references{XRT/3d is a product of
  KL Group Inc.,
  260 King Street East,
  Toronto, Ontario,
  CANADA  M5A 1K3,
  (800) 663-4723 or (416) 594-1026,
  Fax: (416) 594-1919    Email: info@klg.com,
  http://www.klg.com
}
\seealso{\code{\link{xrt.dump}}, \link{\code{xrt.read}}, \link{\code{contour}},\link{\code{image}}
}
\examples{
x<-seq(-2*pi,2*pi,length=20)
y<-seq(-pi,pi,length=10)
z<-outer(x,y,function(x,y)sin(x+y))+0.5*rnorm(10*20)
xrt.plot(x,y,z)
}
\keyword{plot}
