"xrt.read" <- function(file="xrt.dat")
  {
    # read grid dims
    tmp<-scan(file,what=list(" ", 0,0),nmax=1)
    if(tmp[[1]]!="GRID"){
      errmsg<-paste(file,"is not an XRT grid file!")
      stop(errmsg)
    }
    nx<-tmp[[2]]
    ny<-tmp[[3]]
    # read NA value
    na<-scan(file,what=list(0),nmax=1,skip=1)[[1]]    
    # read grid spacing dx, dy 
    dg<-scan(file,what=list(c(0,0)),nmax=1,skip=2)[[1]]
    dx<-dg[1]
    dy<-dg[2]
    # read SW-corner of grid
    tmpsw<-scan(file,what=list(c(0,0)),nmax=1,skip=3)[[1]]
    x0<-tmpsw[1]
    y0<-tmpsw[2]
    x<-seq(x0,by=dx,length=nx)
    y<-seq(y0,by=dy,length=ny)
    # read z matrix
    mat<-matrix(scan(file,what=c(rep(0,nx)),skip=4),nx,ny,byrow=F)
    mat[mat==na]<-NA
    list(x=x,y=y,z=mat)
  }
