#include "krige_grid.h"


void krige_grid__(double *xsw,
	    double *ysw,
            double *xne,
	    double *yne,
            double *angle,
	    int *nx,
	    int *ny,                 
	    double *dx,
	    double *dy,
	    double *xg,
            double *yg,
	    double *zg,
	    double *varg,
	    int *dog,
	    double *lon,
	    double *lat,
	    double *z,
	    int *extrap,
	    int *n,
	    int *covtype,
	    double *covpar,
	    double *covmat,
		int *ldcov,
		int *extcov,
            int *trend,
	    int *ntrend,
	    double *rsearch,
	    int *nsearch,
	    int *nsmin,
	    int *nsmax,
	    int *mode,
	    double *mu,
	    double *lambda,
            int *bits,
		  int *retlm,
	    int *ierr){

    /* Simple Fortran  wrapper*/
 krige_grid(xsw,
	    ysw,
            xne,
	    yne,
            angle,
	    nx,
	    ny,                 
	    dx,
	    dy,
	    xg,
            yg,
	    zg,
	    varg,
	    dog,
	    lon,
	    lat,
	    z,
	    extrap,
	    n,
	    covtype,
	    covpar,
	    covmat,
	    ldcov,
	    extcov,
            trend,
	    ntrend,
	    rsearch,
	    nsearch,
	    nsmin,
	    nsmax,
	    mode,
	    mu,
	    lambda,
            bits,
	    retlm,
	    ierr);
    }

void krige_grid(double *xsw,
	    double *ysw,
            double *xne,
	    double *yne,
            double *angle,
	    int *nx,
	    int *ny,                 
	    double *dx,
	    double *dy,
	    double *xg,
            double *yg,
	    double *zg,
	    double *varg,
	    int *dog,
	    double *lon,
	    double *lat,
	    double *z,
	    int *extrap,
	    int *n,
	    int *covtype,
	    double *covpar,
	    double *covmat,
		int *ldcov,
		int *extcov,
            int *trend,
	    int *ntrend,
	    double *rsearch,
	    int *nsearch,
	    int *nsmin,
	    int *nsmax,
	    int *mode,
	    double *mu,
	    double *lambda,
            int *bits,
		int *retlm,
	    int *ierr){

    int nz=(*nx)*(*ny), ldc0=(*n),
	ldfwrk=(*n),ldmu=(*ntrend), ldlmbd=(*n), nkwork=(*n+*ntrend);
    double *c0vec, *fwork, *f0work, *dist, *kwork,
	   *rhswork, cov0;
    int *indsnb, *indsna, *indsrt, *ipiv;

#ifndef TRANSIENT
    c0vec=Calloc((size_t)(*n),double);    
    fwork=Calloc((size_t)(*n)*(*ntrend),double);    
    f0work=Calloc((size_t)(*ntrend),double);    
    dist=Calloc((size_t)(*n),double);    
    indsnb=Calloc((size_t)(*n),int);    
    indsna=Calloc((size_t)(*n),int);    
    indsrt=Calloc((size_t)(*n),int); 
    kwork=Calloc((size_t)(*n+*ntrend)*(*n+*ntrend),double); 
    rhswork=Calloc((size_t)(*n+*ntrend),double);
    ipiv=Calloc((size_t)(*n+*ntrend),int);
#else
    c0vec=(double *) R_alloc((*n),sizeof(double));
    fwork=(double *) R_alloc((*n)*(*ntrend),sizeof(double));    
    f0work=(double *) R_alloc((*ntrend),sizeof(double));    
    dist=(double *) R_alloc((*n),sizeof(double));
    indsnb=(int *) R_alloc((*n),sizeof(int));
    indsna=(int *) R_alloc((*n),sizeof(int));
    indsrt=(int *) R_alloc((*n),sizeof(int));
    kwork=(double *) R_alloc((*n+*ntrend)*(*n+*ntrend),sizeof(double)); 
    rhswork=(double *) R_alloc((*n+*ntrend),sizeof(double)); 
    ipiv=(int *) R_alloc((*n+*ntrend),sizeof(int)); 
#endif

    
    F77_CALL(krggrd)(xsw, 
		     ysw, 
		     xne, 
		     yne, 
		     angle, 
		     nx, 
		     ny, 
		     &nz, 
		     dx, 
		     dy, 
		     xg, 
		     yg, 
		     zg, 
		     varg, 
		     dog, 
		     lon, 
		     lat, 
		     z, 
		     extrap, 
		     n, 
		     covtype, 
		     covpar, 
		     covmat, 
		     ldcov, 
		     c0vec, 
		     &ldc0, 
		     &cov0, 
		     extcov, 
		     trend, 
		     ntrend, 
		     rsearch, 
		     nsearch, 
		     nsmin, 
		     nsmax, 
		     fwork, 
		     &ldfwrk, 
		     f0work, 
		     dist, 
		     indsnb, 
		     indsna, 
		     indsrt, 
		     kwork, 
		     &nkwork, 
		     rhswork, 
		     ipiv, 
		     mode, 
		     mu, 
		     &ldmu, 
		     lambda, 
		     &ldlmbd, 
		     bits,
		     retlm,
		     ierr);
    

#ifndef TRANSIENT
    Free(ipiv);
    Free(rhswork);
    Free(kwork);
    Free(indsrt);
    Free(indsna);
    Free(indsnb);
    Free(dist);
    Free(f0work);
    Free(fwork);
    Free(c0vec);
#endif
    
}
