      SUBROUTINE KRIGE(LON0,LAT0,DO0,INDDO,N0,LON,LAT,Z,N,
     .                 COVTYPE,COVPAR,COVMAT,LDCOV,C0VEC,LDC0,COV0,
     .                 TREND,NTREND,RSEARCH,NSEARCH,NSMIN,NSMAX,FWORK,
     .                 LDFWRK,F0WORK,LDF0WK,DIST,INDSNB,INDSNW,INDSRT,
     .                 KWORK,NKWORK,RHSWORK,IPIV,MODE,MU,Z0,LAMBDA,
     .                 LDLMBD,VAR,SNBBIT,USESBBT,IERR)

      IMPLICIT NONE
      INTEGER N,TREND,NTREND,MODE,IERR,NSEARCH,NSMIN,NSMAX,IPIV(*),
     .        INDSNB(*),INDSNW(*),INDSRT(*),COVTYPE,DO0(*),INDDO(*),
     .        LDCOV,LDC0,LDFWRK,LDLMBD,N0,NKWORK,USESBBT,SNBBIT(*),
     .        LDF0WK
      DOUBLE PRECISION LAT0(*),LON0(*),LAT(*),LON(*),Z(*),
     .                 COVMAT(LDCOV,*),C0VEC(LDC0,*),COV0,COVPAR(3),
     .                 FWORK(LDFWRK,*),F0WORK(LDF0WK,*),MU(NTREND,*),
     .                 Z0(*),LAMBDA(LDLMBD,*),VAR(*),
     .                 RSEARCH,KWORK(NKWORK,*),RHSWORK(NKWORK,*),
     .                 DIST(*)

c     subroutine for universal kriging
c
c     This subroutine solves a kriging system for n0 prediction points 
c     simultaneously. It first finds the superset of all search
c     neighbourhoods, selects the apropriate submatrix from COVMAT, 
c     determines the covariance vectors C0VEC for each prediction point,
c     builds the design matrix FWORK and the design vectors F0WORK and 
c     then solves a linear system with multiple right hand sides (DGESV).
c     This routine is meant to be called from KRGGRD, which builds small
c     blocks (tiles) from a grid and sends them to KRIGE for simultaneous
c     computation.
c
c     input:
c     LAT0,LON0  coordinates of prediction point(s) x_0        (n0 x 1)
c     N0         number of prediction points 
c     DO0        0/1 indicator which points to use             (n0 x 1)
c                (used for restricting output to convex hull)
c     LAT,LON    coordinates of data points x_i                (n x 1)
c     Z          data values                                   (n x 1)
c     COVMAT        covariance matrix = C(x_i,x_j)             (n x n)
c     LDCOV      leading dimension of COVMAT
c     C0VEC         covariance vector(s) = C(x_i,x_0)          (n x n0)
c     COV0       variance = C(0)
c     LDC0       leading dimension of COVEC
c     N          number of data points
c     TREND      order of trend             (0,1,2)
c     NTREND     number of trend parameters (1,3,6)
c     FWORK      work array for design matrix               (n x ntrend)
c     LDFWRK     leading dimension of FWORK
c     F0WORK     work array for design vector(s)            (ntrend x n0)
c     MODE       operation mode:
c                1: predict only z0 at (lon0,lat0)
c                   calculates z0, mu and lambda
c                2: calculate only prediction variance
c                   calculates var, mu, and lambda (z is NOT used!)
c                3: both
c                   calculates z0, var, mu, and lambda
c     RSEARCH    fixed search radius
c     NSEARCH    fixed number of points in search neighbourhood
c     NSMIN      min number of points in search neighbourhood
c     NSMAX      max number of points in search neighbourhood
c     USESBBT    indicator to produce SNBBIT (see below) (0/1)
c
c     work arrays and local variables:
c     DIST       distance vector for search neighbourhood     (n x 1) 
c     INDSNB     index vector for search neighbourhood        (n x 1)
c     INDSRT     index vector for sorted search neighbourhood (n x 1)
c     KWORK      krige matrix                      (n + ntrend x n + ntrend)
c     NKWORK     dim of KWORK (=n+ntrend)
c     RHSWORK    right hand side                   (n + ntrend x 1)
c     NS         size of search neigbourhood
c
c     output:
c     MU         langrange parameter (=est. trend parameter)   (ntrend x 1)
c     Z0         predicted value
c     VAR        kriging variance           
c     LAMBDA     kriging weights                               (n x 1)
c     IERR       error code
c     SNBBIT     vector with 0-1 indicators of searchneighbourhood indices
c                SNBBIT(I) = 1 if (LON(I),LAT(I)) falls into search
c                neigbourhood                                  (n x 1)
c
c     solves the krige system (with n0>=1 right hand sides / solutions):
c
c     [ COVMAT| FWORK ] [ LAMBDA_1 | ..._N0]   [ C0VEC_1 | ..._N0 ]
c     [-------+-------] [ ---------+------ ] = [ --------+------- ]
c     [ FWORK'|   0   ] [  - MU_1  ] ..._N0]   [ F0WORK_1| ..._N0 ]
c
c     Z0  = LAMBDA' * Z
c     VAR = COV0 - LAMBDA' * C0VEC + MU' * F0WORK
      
      DOUBLE PRECISION DDOT, COVFN
      EXTERNAL DDOT, COVFN

      EXTERNAL DVEC, DPSORT, DGESV, DGEMV, SRCHNB, DESIGN

c     local variables
      INTEGER I,J,INFO,NS,NDO,dbglvl
      CHARACTER TRANS*1
      CHARACTER*16 NAME

      dbglvl=1
c     some checks
      IF (MODE.NE.1 .AND. MODE.NE.2 .AND. MODE.NE.3) THEN
         IERR=1
         RETURN
      END IF
      IF (NSMIN.LT.0 .OR. NSMIN.GT.N) THEN
         NSMIN=0
      END IF
      IF (NSMAX.LT.0 .OR. NSMAX.GT.N) THEN
         NSMAX=N
      END IF
c     omit points with do0=0
c      name="do0"
c      call imatpr(do0,n0,1,n0,name,dbglvl)

      I=0
      J=0
      NDO=0
 3000 I=I+1
      IF (DO0(I).EQ.0) GO TO 3001
      J=J+1
      NDO=J
      INDDO(J)=I
 3001 IF (I.LT.N0) GO TO 3000
      
      IF (NDO.EQ.0) THEN 
         RETURN
      END IF
      
c      name="inddo"
c      call imatpr(inddo,ln0,1,n0,name,dbglvl)

c     determine search neighbourhood
      CALL SRCHNB(LON0,LAT0,DO0,INDDO,N0,NDO,LON,LAT,N,NS,
     .            RSEARCH,NSEARCH,NSMIN,NSMAX,
     .            INDSRT,INDSNB,INDSNW,DIST)
      if (usesbbt.ne.0) then
         do 1212 i=1,n
            if (indsnb(i).ne.0) then
               snbbit(indsnb(i))=1
            else
               snbbit(indsnb(i))=0
            end if
 1212    continue
      end if
c      name="indsnb\0"
c      call imatpr(name,indsnb,n,1,n,1)
c      name="indsnw\0"
c      call imatpr(name,indsnw,n,1,n,1)
c      name="indsrt\0"
c      call imatpr(name,indsrt,n,1,n,1)
c      write(*,*) "ns:",ns
c     prepare the design matrix
      CALL DESIGN(LON,LAT,N,INDSNB,NS,LON0,LAT0,N0,INDDO,NDO,
     .            FWORK,LDFWRK,F0WORK,LDF0WK,NTREND,TREND,IERR)

c      name="fwork\0"
c      call matpr(name,fwork,ns,ntrend,ldfwrk,1)

c     prepare the covariance vector(s)
      IF (COVTYPE.NE.0) THEN
         COV0=COVPAR(1)+COVPAR(2)
         DO 1000 I=1,N
            DO 1001 J=1,NDO
               C0VEC(I,INDDO(J))=COVFN(COVTYPE,COVPAR,
     .                        SQRT((LON(I)-LON0(INDDO(J)))
     .                              *(LON(I)-LON0(INDDO(J)))+
     .                             (LAT(I)-LAT0(INDDO(J)))
     .                              *(LAT(I)-LAT0(INDDO(J)))))
 1001       CONTINUE
 1000    CONTINUE
      END IF

c     prepare the krige matrix
c      name="covmat\0"
c      call matpr(covmat,ldcov,n,n,name,dbglvl)
      DO 20 I=1,NS
         DO 21 J=1,NS
            KWORK(I,J)=COVMAT(INDSNB(I),INDSNB(J))
c            write(*,*) i,j,kwork(i,j)
 21      CONTINUE
 20   CONTINUE
      DO 30 I=1,NS
         DO 31 J=1,NTREND
            KWORK(I,J+NS)=FWORK(I,J)
            KWORK(J+NS,I)=FWORK(I,J)
c            write(*,*) i,j,kwork(i,j+ns),kwork(j+ns,i)
 31      CONTINUE
 30   CONTINUE
      DO 32 I=NS+1,NS+NTREND
         DO 33 J=NS+1,NS+NTREND
            KWORK(I,J)=0
c            write(*,*) i,j,kwork(i,j)
 33      CONTINUE
 32   CONTINUE

c     prepare the right hand side(s)
      DO 300 J=1,NDO
         DO 40 I=1,NS
            RHSWORK(I,J)=C0VEC(INDSNB(I),inddo(J))
 40      CONTINUE
         DO 41 I=1,NTREND
            RHSWORK(I+NS,J)=F0WORK(I,inddo(J))
 41      CONTINUE
 300  CONTINUE
      
c     solve the system
C      name="kwork\0"
C      call matpr(name,kwork,ns+ntrend,ns+ntrend,nkwork,dbglvl)
C      name="rhswork\0"
C      call matpr(name,rhswork,ns+ntrend,ndo,nkwork,dbglvl)
      CALL DGESV(NS+NTREND,NDO,KWORK,NKWORK,IPIV,RHSWORK,NKWORK,INFO)
C      name="lsg\0"
C      call matpr(name,rhswork,ns+ntrend,ndo,nkwork,dbglvl)
      
      IF (INFO.NE.0) THEN
         IERR=INFO
c         write(*,*) "error in krige:", info
         DO 54 I=1,N0
            DO0(INDDO(I))=-1
 54      CONTINUE
         RETURN
      END IF

      DO 401 J=1,N0
         DO 52 I=1,N
            LAMBDA(I,J)=0
 52      CONTINUE
         DO 53 I=1,NTREND
            MU(I,J)=0
 53      CONTINUE
 401  continue
      DO 400 J=1,NDO
         DO 50 I=1,NS
c            write (*,*)i,indsnb(i),j
            LAMBDA(INDSNB(I),inddo(J))=RHSWORK(I,J)
 50      CONTINUE
         
         DO 51 I=1,NTREND
            MU(I,inddo(J))=-RHSWORK(I+NS,J)
 51      CONTINUE
 400  CONTINUE
      
c     calculate variance
      IF (MODE.EQ.2 .OR. MODE.EQ.3) THEN
c         name="lambda"
c         call matpr(lambda,ldlmbd,n0,n,name,dbglvl)
c         name="c0"
c         call matpr(c0,ldc0,n0,n,name,dbglvl)
c      name="mu"
c      call matpr(mu,ntrend,n0,ntrend,name,dbglvl)
c      name="f0work"
c      call matpr(f0work,ntrend,ln0,ntrend,name,dbglvl)
         DO 500  I=1,NDO
            VAR(INDDO(I)) = COV0 - DDOT(N,LAMBDA(1,INDDO(I)),
     .                                  1,C0VEC(1,INDDO(I)),1)
     .                      + DDOT(NTREND,MU(1,INDDO(I)),1,
     .                             F0WORK(1,INDDO(I)),1)
 500     CONTINUE
      END IF
c     calculate predicted value(s)
c      name="z"
c      call matpr(z,n,1,n,name,dbglvl)
         IF (MODE.EQ.1 .OR. MODE.EQ.3) THEN
            TRANS="T"
            CALL DGEMV(TRANS,N,N0,1.0D0,LAMBDA,LDLMBD,Z,1,0.0D0,Z0,1)
         END IF
c      name="z0\0"
c      call matpr(name,z0,n0,1,n0,dbglvl)
      RETURN
      END

