krige.points <- function(point.obj,
                         at,
                         var.mod.obj,
                         x,y,
                         maxdist = NULL,
                         extrap  = FALSE,
                         border  = NULL,
                         trend   = 0,
                         rsearch = 0,
                         nsearch = 0,
                         nsmin   = -1,
                         nsmax   = -1,
                         mode    = 3,
                         duplicate = "error",
                         dupfun = NULL)
  {
    nx<-length(x)
    ny<-length(y)
    if(nx!=ny)stop("length of x and y differ!")
    npts<-nx
    if(npts==0)
      stop("no prediction points given!")
    n<-length(point.obj$x)
    
    at <- point.obj[[match(at, names(point.obj))]]

    if (!inherits(point.obj, "point")) 
      stop("point.obj must be of class, \"point\".\n")
    if (!inherits(var.mod.obj, "variogram.model")) 
      stop("var.mod.obj must be of class, \"variogram.model\".\n")
    if(mode==1 && length(at)!=n) stop("length of x and z differ\n")
    if(rsearch>0 & nsearch>0)
      stop("specify only one of rsearch and nsearch\n")
    if(nsmin>nsmax)
      stop("nsmin>nsmax\n")
#    if(rsearch>0){
#      if(nsmin==0) nsmin<-ceiling(n*0.1)
#      if(nsmax==0) nsmax<-ceiling(n*0.9)
#    }
    if(trend==0) ntrend<-1
    if(trend==1) ntrend<-3
    if(trend==2) ntrend<-6

    covtype<-switch(attr(var.mod.obj,"type"),
                    exponential=1,
                    gaussian=2,
                    spherical=3,
                    linear=4,
                    0)
    c0<-0
    covmat<-matrix(0,n,n)
     
    snbbit<-rep(0,1+n*npts)
    snbbit[1]<-1

        # eliminate duplicates:
    xy <- paste(point.obj$x, point.obj$y, sep =",")
    idup <- match(xy, xy)
    if(duplicate=="user" && !is.function(dupfun))
      stop("duplicate=\"user\" requires dupfun to be set to a function")
    if(duplicate!="error")
      {
        centre <- function(x) {
          switch(duplicate,
                 mean = mean(x),
                 median = median(x),
                 user = dupfun(x))
        }
        if(duplicate!="strip"){
          at <- unlist(lapply(split(at,idup), centre))
          ord <- !duplicated(xy)
          point.obj$x <- point.obj$x[ord]
          point.obj$y <- point.obj$y[ord]
          n <- length(point.obj$x)
        }
      else{
        ord <- (hist(idup,plot=F,freq=T,breaks=seq(0.5,max(idup)+0.5,1))$counts==1)
        point.obj$x <- point.obj$x[ord]
        point.obj$y <- point.obj$y[ord]
        at <- at[ord]
        n <- length(point.obj$x)
      }
      }
    else
      if(any(duplicated(xy)))
        stop("duplicate data points")
    
    dopts<-rep(1,length=npts)
    if (!extrap) {
      if(is.null(border))
        dopts <- in.chull(x,y,point.obj$x,point.obj$y)
      else {
        if(is.null(border$x) | is.null(border$y) | length(border$x)!=length(border$y))
          stop("border argument wrong!")
        dopts <- in.polygon(x,y, border$x,border$y)
      }
      # workaround for int <-> unsigned int problem on alpha platform:
      dopts <- abs(as.numeric(dopts))
    }    
    
    ans<-.Fortran("krgpts",
                  x=as.double(x),
                  y=as.double(y),                 
                  z=double(npts),              
                  var=double(npts),
                  npts=as.integer(npts),                
                  dopts=as.integer(dopts),
                  lon=as.double(point.obj$x),
                  lat=as.double(point.obj$y),
                  zdat=as.double(at),
                  n=as.integer(n),
                  covtype=as.integer(covtype),
                  covpar=as.double(var.mod.obj$parameters),
                  covmat=as.double(covmat),
                  ldcov=as.integer(n),
                  c0vec=double(n),
                  ldc0=as.integer(n),
                  c0=as.double(c0),
                  extcov=as.integer(0), # no external covariance matrix
                  trend=as.integer(trend),
                  ntrend=as.integer(ntrend),
                  rsearch=as.double(rsearch),
                  nsearch=as.integer(nsearch),
                  nsmin=as.integer(nsmin),
                  nsmax=as.integer(nsmax),
                  fwork=double(n*ntrend),
                  ldfwrk=as.integer(n),
                  f0work=double(ntrend),
                  dist=double(n),
                  indsnb=integer(n),
                  indsna=integer(n),
                  indsrt=integer(n),
                  kwork=double((n+ntrend)*(n+ntrend)),
                  nkwork=as.integer(n+ntrend),
                  rhswork=double(n+ntrend),
                  ipiv=integer(n+ntrend),
                  mode=as.integer(mode),
                  mu=double(ntrend),
                  lambda=double(n),
                  ldlmbd=as.integer(n),
                  bits=as.integer(c(integer(npts),snbbit)),
                  ierr=integer(1),
                  .Package="rgeostat")
    
#    ans<-krige.solve(s$x,s$y,point.obj$x,point.obj$y,
#                     at,covmat,c0vec,c0,trend,rsearch,nsmin,nsmax,mode)

    retval<-list(x=ans$x,
                 y=ans$y,
                 z=ans$z,
                 var=ans$var,
                 done=ans$dopts,
                 snb=matrix(ans$bits[(npts+2):(npts+n*npts+1)],nrow=n,ncol=npts,byrow=F))
    retval    
  }
