      SUBROUTINE KRGGRD(XSW,YSW,XNE,YNE,ANGLE,NX,NY,NZ,
     .                  DX,DY,XG,YG,ZG,VARG,DOG,
     .                  LON,LAT,Z,EXTRAP,N,
     .                  COVTYPE,COVPAR,COVMAT,LDCOV,C0VEC,LDC0,COV0,
     .                  EXTCOV,TREND,NTREND,RSEARCH,NSEARCH,NSMIN,NSMAX,
     .                  FWORK,LDFWRK,F0WORK,DIST,INDSNB,INDSNA,INDSRT,
     .                  KWORK,NKWORK,RHSWORK,IPIV,MODE,MU,LAMBDA,LDLMBD,
     .                  BITS,IERR)

      IMPLICIT NONE
      INTEGER NX,NY,NZ,N,COVTYPE,TREND,NTREND,
     .        NSEARCH,NSMIN,NSMAX,MODE,IERR,INDSNB(*),INDSNA(*),
     .        INDSRT(*),IPIV(*),EXTRAP,DOG(NX,*),EXTCOV,LDCOV,
     .        LDC0,LDFWRK,LDLMBD,NKWORK,bits(*)
      DOUBLE PRECISION XSW,YSW,XNE,YNE,ANGLE,DX,DY,
     .                 XG(*),YG(*),ZG(NX,*),VARG(NX,*),
     .                 LON(*),LAT(*),Z(*),COVMAT(LDCOV,*),C0VEC(LDC0,*),
     .                 COV0,RSEARCH,FWORK(LDFWRK,*),F0WORK(NTREND,*),
     .                 DIST(*),KWORK(NKWORK,*),RHSWORK(*),MU(*),
     .                 LAMBDA(*),
     .                 COVPAR(*) 

c     subroutine for kriging prediction on a grid
c     
c     This subroutine takes the grid specification and calls KRIGE
c     (see below) on the grid points.
c
c     
c            [1,1]                              ne       
c              +-------------------------------+    
c              | o   o   o   o   o   o   o   o |      o    -- grid points (i,j)
c              |(1,1)                       x  |    
c              | o   o   o   o   o   o   o   o |    
c              |                               |    
c              | o   o   o   o   o   o   o   o |    
c              |                               |    
c              | o   o   o   o   o   o   o   o |      x    -- user specified
c              |                               |_             sw/ne corners
c       N      | o   o   o   o   o   o   o   o | \ 
c        +     |                               |  > dy
c         \    | o   o   o   o   o   o   o   o |_/
c          \   |                               |    
c           \  | o   o   o   o   o   o   o   o |     
c            \ |  x                     (ny,nx)|         
c             \| o   o   o   o   o   o   o   o |    
c              +-------------------------------+
c            sw                  \_ _/               
c                                  v
c                                   dx
c     parameters
c     XSW,YSW          lon/lat of sw-corner
c     XNE,YNE          lon/lat of ne-corner
c     ANGLE            angle to add to N-S 
c     NX,NY            no. of grid points in x / y direction (at least 2)
c     NZ               overall no of grid points (=NX*NY)
c     XG,YG,ZG,VARG    arrays to hold the output (grid coords. and 
c                      prediction)
c     LON,LAT,Z,N      data set
c     X0,Y0,Z0,VAR0    arrays to hold the input/output (grid coords. and 
c                      prediction) for one tile.
c     EXTCOV           indicates whether KRGGRD has to calculate the 
c                      covariance matrix itself or should use an external one 
c     ...              ... other work arrays to pass through to KRIGE

      DOUBLE PRECISION COVFN
      EXTERNAL COVFN

      EXTERNAL KRIGE, MATPR

c     local variables
      INTEGER I,J,K,L, INDDO(1), DO0(1), usesbbt, pcnt
      DOUBLE PRECISION DELTA, X0, Y0, Z0, VAR0
      CHARACTER*16 NAME

c     constants
      integer dbglvl
      dbglvl=1

c     build/check grid parameters:
      IF (NX*NY.NE.NZ) THEN
c          write(*,*) "wrong value of nz (should be nx*ny)"
         IERR=1
         RETURN
         END IF

c      IF (NX.GE.2 .AND. DX.EQ.0) THEN 
c         DX=(XNE-XSW)/(NX-1)
c         write (*,*)dy
c      ELSE IF (DX.GE.0) THEN
c         NX=AINT((XNE-XSW)/DX)+1
c         DELTA=XSW+NX*DX-XNE
c         XSW=XSW-DELTA/2
c         XNE=XNE+DELTA/2
c      ELSE
c         write(*,*) "wrong x dimension of grid"
c         IERR=1
c         RETURN
c      END IF
c
c      IF (NY.GE.2 .AND. DY.EQ.0) THEN 
c         DY=(YNE-YSW)/(NY-1)
c         WRITE (*,*)DY
c      ELSE IF (DY.GE.0) THEN
c         NY=AINT((YNE-YSW)/DY)+1
c         DELTA=YSW+NY*DY-YNE
c         YSW=YSW-DELTA/2
c         YNE=YNE+DELTA/2
c      ELSE
c         write(*,*) "wrong y dimension of grid"
c         IERR=1
c         RETURN
c      END IF

c      IF (NTX.GE.1) THEN 
c         ITX=INT(NX/NTX)+1
c      ELSE IF (ITX.GE.0) THEN
c         NTX=INT(NX/ITX)+1
c      ELSE
c         write(*,*) "wrong x dimension of tiles"
c         IERR=1
c         RETURN
c      END IF

c      IF (NTY.GE.1) THEN 
c         ITY=INT(NY/NTY)+1
c      ELSE IF (ITY.GE.0) THEN
c         NTY=INT(NY/ITY)+1
c      ELSE
c         write(*,*) "wrong y dimension of tiles"
c         IERR=1
c         RETURN
c      END IF

      DO 1 I=1,NY
         YG(I)=YSW+DY*(I-1)
 1    CONTINUE
      DO 2 J=1,NX
         XG(J)=XSW+DX*(J-1)
 2    CONTINUE

c      name="xg"
c      call matpr(xg,nx,1,nx,name,dbglvl)
c      name="yg"
c      call matpr(yg,ny,1,ny,name,dbglvl)

c     prepare the covariance matrix
      IF (EXTCOV.NE.1) THEN
         DO 1000 I=1,N
            DO 1001 J=I,N
               COVMAT(I,J)=COVFN(COVTYPE,COVPAR,
     .                        SQRT((LON(I)-LON(J))*(LON(I)-LON(J))+
     .                             (LAT(I)-LAT(J))*(LAT(I)-LAT(J))))
               COVMAT(J,I)=COVMAT(I,J)
 1001       CONTINUE
 1000    CONTINUE
      END IF

c      call matpr(cov,n,n,n,"covmat",dbglvl)

c     rotation:
c     call drotg(nz,xgwork,1,ygwork,1,COS(ALPHA),SIN(ALPHA))
c     loop over all points and pass them to KRIGE:
      if (bits(1+nz).ne.0) then
         usesbbt=1 
      end if
      PCNT=0
      DO 20 I=1,NX
         DO 10 J=1,NY
            PCNT=PCNT+1
            BITS(I+NY*(J-1)) = PCNT
            X0=XG(I)
            Y0=YG(J)
            DO0(1)=DOG(I,J)
c           the main work is now done by KRIGE:
            CALL KRIGE(X0,Y0,DO0,INDDO,1,LON,LAT,Z,N,
     .                 COVTYPE,COVPAR,COVMAT,LDCOV,C0VEC,LDC0,COV0,
     .                 TREND,NTREND,RSEARCH,NSEARCH,NSMIN,NSMAX,FWORK,
     .                 LDFWRK,F0WORK,NTREND,
     .                 DIST,INDSNB,INDSNA,INDSRT,KWORK,
     .                 NKWORK,RHSWORK,IPIV,MODE,MU,Z0,LAMBDA,LDLMBD,
     .                 VAR0,BITS(nz+2+(pcnt-1)*n),USESBBT,IERR)
c            if (usesbbt.ne.0) bits(nz+1)=TCNT

c            name="xg"
c            call matpr(xg,nx,1,nx,name,dbglvl)
c            name="yg"
c            call matpr(yg,ny,1,ny,name,dbglvl)

c           extract results for this grid point
            IF (IERR.NE.0) THEN
               DOG(I,J)=DO0(1)
            ELSE
               ZG(I,J)=Z0
               VARG(I,J)=VAR0
            END IF
 10      CONTINUE
 20   CONTINUE


      RETURN
      END
