#ifndef PVM_TILES_H
#define PVM_TILES_H

tile_job* create_job(int i_lower, 
		     int i_upper, 
		     int j_lower, 
		     int j_upper,
		     size_msg param_size);

void pvm_krige_tiles(double *lon,
		     double *lat,
		     double *z,
		     double *xgwork,
		     double *ygwork,
		     int *dog,
		     static_msg param,
		     size_msg param_size,
		     double *zg,
		     double *varg,
		     int *gridcnt);

void send_job(tjqueue_t *queue_entry, tile_job_queue_t *t_j_q, int tid);
tjqueue_t* find_queueentry_by_id(tile_job_queue_t *t_j_q, int id);
tjqueue_t* find_next_queueentry_todo(tile_job_queue_t *t_j_q);
tile_host_t* find_hostlistentry_by_tid(tile_hostlist_t *t_h_l, int tid);

#endif // PVM_TILES_H
