pvmkrige <-
function(pointx,pointy,pointz,plen,sx,sy,slen,zhat,sigma2hat,model,parameter,invmatrix,sdo)    {                      
    # IN => pointx/pointy/pointz - sample points (m)
    # IN => sx/sy - grid where to calculate the points (n*n)
    # OUT <= zhat - estminated values for points (sx/sy)  (n*n)
    # OUT <= sigma2hat - error estimate  1 
    # IN => model        1
    # IN => parameter    3
    # IN => invmatrix - inverted matrix    (a*a)
    gvector<-c(rep(0, plen+1))
    dst<-c(rep(0, plen))
    lambda_hat<-c(rep(0,plen+1))

    ret<-.C("pvmkrige",
              as.double(pointx),
	      as.double(pointy),
	      as.double(pointz),
	      as.integer(plen),
	      as.double(sx),
	      as.double(sy),
	      as.integer(slen),
              zhat=as.double(zhat),
	      sigma2hat=as.double(sigma2hat),
	      as.character(model),
	      as.double(parameter),
	      as.double(invmatrix),
              as.double(gvector),
	      as.double(dst),
   	      as.double(lambda_hat),
	      as.double(sdo),
           )
    list(ret$zhat,ret$sigma2hat)
}

