\name{krige}
\title{Kriging}
\usage{krige(prdpnt, point.obj, v1, var.mod.object,maxdist=NULLi,extrap=F) }
\alias{krige}
\arguments{
\item{prdpnt}{a point object, generated by \code{point()}, at which prediction is carried out}
\item{point.obj}{a point object, generated by \code{point()}, containing the sample points and data}
\item{v1}{the variable, contained in \code{point.obj}, for which prediction will be carried out}
\item{maxdist}{an optional maximum distance. If entered, then only sample points (i.e, in point.obj) within maxdist of each
prediction point will be used to do the prediction at that point. If not entered, then all n sample points will be used to make
the prediction at each point.}
\item{extrap}{logical, indicates if prediction outside the convex hull of data points should be done, default \code{FALSE}}
}
\value{A point object which is a copy of the prdpnt object with two new variables, \code{zhat} and \code{sigma2hat}, which are,
repspectively, the predicted value and the kriging variance. }
\description{Carry out spatial prediction (or kriging). }
\seealso{\code{\link{}},}
\examples{

# a single point:
prdpnt <- point(dataframe(list(x=180000,y=331000)))
prdpnt <- krige(prdpnt, maas.pts, 'zinc', maas.vmod)

# kriging on a grid (slow!)
grid <- list(x=seq(min(maas$x),max(maas$x),by=100),
             y=seq(min(maas$x),max(maas$x),by=100))
grid$krige <- krige(grid$pts,maas.pts,'zinc',maas.vmod,
                    maxdist=1000,extrap=F)
image(grid$x,grid$y,grid$krige$zhat)
contour(grid$x,grid$y,
        matrix(grid$krige$zhat,length(grid$x),length(grid$y)),
        add=T)
}
\references{
http://www.gis.iastate.edu/SGeoStat/homepage.html
}
