\name{est.variogram}
\title{Variogram Estimator}
\usage{est.variogram(point.obj, pairs.obj, v1, v2=v1) }
\alias{est.variogram}
\arguments{
\item{point.obj}{a point object generated by \code{point()}}
\item{pairs.obj}{a pairs object generated by \code{pairs()}}
\item{v1}{a variable to calculate semivariogram for}
\item{v2}{an optional variable name, if entered cross variograms will be created between \code{v1} and \code{v2}}
}
\value{A variogram object:
\item{lags}{vector of lag identifiers}
\item{bins}{vector of midpoints of each lag}
\item{classic}{vector of classic variogram estimates for each lag}
\item{robust}{vector of robust variogram estimates for each lag}
\item{med}{vector of median variogram estimates for each lag}
\item{n}{vector of the number of pairs in each lag}
}
\description{Calculate empirical variogram estimates. 

An object of class \code{variogram} contains empirical variogram estimates generated from a point object and a pairs object. A
variogram object is stored as a data frame containing six columns: \code{lags}, \code{bins}, \code{classic}, \code{robust}, \code{med}, and \code{n}. The length of each
vector is equal to the number of lags in the pairs object used to create the variogram object, say l. The \code{lags} vector contains the
lag numbers for each lag, beginning with one (1) and going to the number of lags (l). The \code{bins} vector contains the spatial midpoint
of each lag. The \code{classic}, \code{robust}, and \code{med} vectors contain the classical,
\deqn{\gamma_{c}(h)=\frac{1}{n}\sum_{(i,j) \in
    N(h)}(z(x_{i})-z(x_{j}))^{2}}{classic(h)= 1/n sum_(i,j)_in_N(h) (z(x_i)-z(x_j))^2 }

robust,
\deqn{\gamma_{m}(h)=\frac{(\frac{1}{n}\sum_{(i,j) \in N(h)}
    (\sqrt{|z(x_{i})-z(x_{j})|}))^{4}}{0.457 +
    \frac{0.494}{n}}}{robust(h)=(1/n sum_(i,j)_in_N(h)
  sqrt(|z(x_i)-z(x_j)|) )^4/(0.457 + 0.494/n)}

and median
 \deqn{\gamma_{m}(h)=\frac{(\median_{(i,j) \in N(h)}
     (\sqrt{|z(x_{i})-z(x_{j})|}))^{4}}{0.457 + \frac{0.494}{|N(h)|}}}{med(h)=(med_(i,j)_in_N(h)
  sqrt(|z(x_i)-z(x_j)|) )^4/(0.457 + 0.494/n)}
 
  variogram estimates for each lag, respectively (see Cressie, 1993, p. 75).
The \code{n} vector contains the number \eqn{|N(h)|} of pairs of points in each lag \eqn{N(h)}. }
\seealso{\code{\link{point}}, \code{\link{pairs}}}
\examples{
maas.v<-est.variogram(maas.pts,maas.pairs,'zinc') 
}
\references{
http://www.gis.iastate.edu/SGeoStat/homepage.html
}
