      SUBROUTINE DMAT(X,Y,D,N,LDD)
      IMPLICIT NONE
      INTEGER N,LDD
      DOUBLE PRECISION X(*),Y(*),D(LDD,*)
c     calculate distances between (X(I),Y(I)) and (X(J),Y(J)), I,J=1..N
 
      INTEGER I,J

      DO 10 I=1,N
         do 20 j=1,n
            D(I,j)=SQRT((X(i)-X(j))*(X(i)-X(j))+(Y(i)-Y(j))*(Y(i)-Y(j)))
 20      continue
 10   CONTINUE

      RETURN
      END
      

      SUBROUTINE DMAT2(X1,Y1,N1,x2,y2,n2,D,LDD)
      IMPLICIT NONE
      INTEGER N1,n2,ldd
      DOUBLE PRECISION X1(*),Y1(*),x2(*),y2(*),D(LDD,*)
c     calculate distances between (X1(I),Y1(I)) and (X2(J),Y2(J)), I,J=1..N
 
      INTEGER I,J

      DO 10 I=1,N1
         do 20 j=1,n2
            D(I,j)=SQRT((X1(i)-X2(j))*(X1(i)-X2(j))+
     .                  (Y1(i)-Y2(j))*(Y1(i)-Y2(j)))
 20      continue
 10   CONTINUE

      RETURN
      END


      SUBROUTINE DSUBMM(A,M,N,IL,JL,IU,JU,LDA,B,LDB,DIR)
      IMPLICIT NONE
      INTEGER M,N,IL,JL,IU,JU,LDA,LDB,DIR
      DOUBLE PRECISION A(LDA,*),B(LDB,*)
      INTEGER I,J,K,L
      K=0
c     copy a part of a matrix into / from a matrix
c     dir > 0 : copy a[il:iu,jl:ju] --> b
c     dir < 0 : copy b --> a[il:iu,jl:ju] 
      DO 20 I=IL,IU
         DO 10 J=JL,JU
            K=I-IU+1
            L=J-JU+1
            IF (DIR.GE.0) THEN
               B(K,L)=A(I,J)
            ELSE IF (DIR.LE.0) THEN
               A(I,J)=B(K,L)
            END IF
 10      CONTINUE
 20   CONTINUE
      RETURN
      END


      SUBROUTINE DSUBMV(A,M,N,IL,JL,IU,JU,LDA,V,DIR)
      IMPLICIT NONE
      INTEGER M,N,IL,JL,IU,JU,LDA,DIR
      DOUBLE PRECISION A(LDA,*),V(*)
      INTEGER I,J,K
      K=0
c     copy a part of a matrix into / from a vector
c     dir > 0 : copy a[il:iu,jl:ju] --> v
c     dir < 0 : copy v --> a[il:iu,jl:ju] 
      DO 20 I=IL,IU
         DO 10 J=JL,JU
            K=K+1
            IF (DIR.GE.0) THEN
               V(K)=A(I,J)
            ELSE IF (DIR.LE.0) THEN
               A(I,J)=V(K)
            END IF
 10      CONTINUE
 20   CONTINUE
      RETURN
      END


      SUBROUTINE DSUBVV(A,N,IL,IU,V,DIR)
      IMPLICIT NONE
      INTEGER N,IL,IU,DIR
      DOUBLE PRECISION A(*),V(*)
c     copy a part of a vector into / from a vector
      IF (DIR.GE.0) THEN
c     copy a[il:iu] --> v
      ELSE IF (DIR.LE.0) THEN
c     copy v --> a[il:iu] 
      END IF
      RETURN
      END


      SUBROUTINE DVEC(X0,Y0,X,Y,D,N)
      IMPLICIT NONE
      INTEGER N
      DOUBLE PRECISION X0,Y0,X(*),Y(*),D(*)
c     calculate distances between (X0,Y0) and (X(I),Y(I))
 
      INTEGER I

      DO 10 I=1,N
         D(I)=SQRT((X0-X(I))*(X0-X(I))+(Y0-Y(I))*(Y0-Y(I)))
 10   CONTINUE

      RETURN
      END


      SUBROUTINE ISUBMV(A,M,N,IL,JL,IU,JU,LDA,V,DIR)
      IMPLICIT NONE
      INTEGER M,N,IL,JL,IU,JU,LDA,DIR
      INTEGER A(LDA,*),V(*)
      INTEGER I,J,K
      K=0
c     copy a part of a matrix into / from a vector
c     dir > 0 : copy a[il:iu,jl:ju] --> v
c     dir < 0 : copy v --> a[il:iu,jl:ju] 
      DO 20 I=IL,IU
         DO 10 J=JL,JU
            K=K+1
            IF (DIR.GE.0) THEN
               V(K)=A(I,J)
            ELSE IF (DIR.LE.0) THEN
               A(I,J)=V(K)
            END IF
 10      CONTINUE
 20   CONTINUE
      RETURN
      END


      
