krige.points <- function(point.obj,
                         at,
                         var.mod.obj,
                         x,y,
                         maxdist = NULL,
                         trend=0,
                         rsearch=0,
                         nsearch=0,
                         nsmin=-1,
                         nsmax=-1,
                         mode=3)
  {
    nx<-length(x)
    ny<-length(y)
    if(nx!=ny)stop("length of x and y differ!")
    npts<-nx
    n<-length(point.obj$x)
    
    at <- point.obj[[match(at, names(point.obj))]]

    if (!inherits(point.obj, "point")) 
      stop("point.obj must be of class, \"point\".\n")
    if (!inherits(var.mod.obj, "variogram.model")) 
      stop("var.mod.obj must be of class, \"variogram.model\".\n")
    if(mode==1 && length(at)!=n) stop("length of x and z differ\n")
    if(rsearch>0 & nsearch>0)
      stop("specify only one of rsearch and nsearch\n")
    if(nsmin>nsmax)
      stop("nsmin>nsmax\n")
#    if(rsearch>0){
#      if(nsmin==0) nsmin<-ceiling(n*0.1)
#      if(nsmax==0) nsmax<-ceiling(n*0.9)
#    }
    if(trend==0) ntrend<-1
    if(trend==1) ntrend<-3
    if(trend==2) ntrend<-6

    covtype<-switch(attr(var.mod.obj,"type"),
                    exponential=1,
                    gaussian=2,
                    spherical=3,
                    linear=4,
                    0)
    c0<-0
    covmat<-matrix(0,n,n)
     

    ans<-.Fortran("krgpts",
                  x=as.double(x),
                  y=as.double(y),                 
                  z=double(npts),              
                  var=double(npts),                 
                  npts=as.integer(npts),                
                  lon=as.double(point.obj$x),
                  lat=as.double(point.obj$y),
                  zdat=as.double(at),
                  n=as.integer(n),
                  covtype=as.integer(covtype),
                  covpar=as.double(var.mod.obj$parameters),
                  covmat=as.double(covmat),
                  c0vec=double(n),
                  c0=as.double(c0),
                  extcov=as.integer(0), # no external covariance matrix
                  trend=as.integer(trend),
                  ntrend=as.integer(ntrend),
                  rsearch=as.double(rsearch),
                  nsearch=as.integer(nsearch),
                  nsmin=as.integer(nsmin),
                  nsmax=as.integer(nsmax),
                  fwork=double(n*ntrend),
                  f0work=double(ntrend),
                  dist=double(n),
                  indsnb=integer(n),
                  indsna=integer(n),
                  indsrt=integer(n),
                  kwork=double((n+ntrend)*(n+ntrend)),
                  nkwork=as.integer(n+ntrend),
                  rhswork=double(n+ntrend),
                  ipiv=integer(n+ntrend),
                  mode=as.integer(mode),
                  mu=double(ntrend),
                  lambda=double(n),
                  ierr=integer(1),
                  .Package="rgeostat")
    
#    ans<-krige.solve(s$x,s$y,point.obj$x,point.obj$y,
#                     at,covmat,c0vec,c0,trend,rsearch,nsmin,nsmax,mode)

    retval<-list(x=ans$x,
                 y=ans$y,
                 z=ans$z,
                 var=ans$var)
    retval    
  }
