krige.grid <- function(point.obj,
                       at,
                       var.mod.obj,
                       xsw=NULL,ysw=NULL,xne=NULL,yne=NULL,
                       dx=NULL,dy=NULL,
                       angle=NULL,
                       maxdist = NULL,
                       extrap = F,
                       trend=0,
                       rsearch=0,
                       nsearch=0,
                       nsmin=-1,
                       nsmax=-1,
                       mode=3)
  {
    if(is.null(angle)) angle<-0
    if(is.null(xsw)) xsw<-min(point.obj$x)
    if(is.null(xne)) xne<-max(point.obj$x)
    if(is.null(ysw)) ysw<-min(point.obj$y)
    if(is.null(yne)) yne<-max(point.obj$y)

    dgx <- xne-xsw
    dgy <- yne-ysw

    if(is.null(dx)) dx <- dgx/20
    if(is.null(dy)) dy <- dgy/20

    nx <- ceiling(dgx/dx)+1
    ny <- ceiling(dgy/dy)+1
    
    at <- point.obj[[match(at, names(point.obj))]]
    n <- length(point.obj$x)
    nz <- nx * ny
    
    dog <- matrix(1, nx, ny)
    if (!extrap) {
      tmpgrd <- cbind(rep(seq(xsw,xne,length=nx),ny),sort(rep(seq(ysw,yne,length=ny),nx)))
      dog <- in.chull(tmpgrd[,1], tmpgrd[,2],point.obj$x,point.obj$y) 
      # workaround for int <-> unsigned int problem on alpha platform:
      dog <- abs(as.numeric(dog))
      dog <- matrix(dog, nx, ny,byrow=F)
    }
    
    extrap<-1*extrap
    
    if (!inherits(point.obj, "point")) 
      stop("point.obj must be of class, \"point\".\n")
    if (!inherits(var.mod.obj, "variogram.model")) 
      stop("var.mod.obj must be of class, \"variogram.model\".\n")
    if(mode==1 && length(at)!=n) stop("length of x and z differ\n")
    if(rsearch>0 & nsearch>0)
      stop("specify only one of rsearch and nsearch\n")
    if(nsmin>nsmax)
      stop("nsmin>nsmax\n")
#    if(rsearch>0){
#      if(nsmin==0) nsmin<-ceiling(n*0.1)
#      if(nsmax==0) nsmax<-ceiling(n*0.9)
#    }
    if(trend==0) ntrend<-1
    if(trend==1) ntrend<-3
    if(trend==2) ntrend<-6

    covtype<-switch(attr(var.mod.obj,"type"),
                    exponential=1,
                    gaussian=2,
                    spherical=3,
                    linear=4,
                    0)
    c0<-0
    covmat<-matrix(0,n,n)
     

    ans<-.Fortran("krggrd",
                  xsw=as.double(xsw),
                  ysw=as.double(ysw),                 
                  xne=as.double(xne),                 
                  yne=as.double(yne),                 
                  angle=as.double(angle),                 
                  nx=as.integer(nx),                 
                  ny=as.integer(ny),                 
                  nz=as.integer(nz),                 
                  dx=as.double(dx),                 
                  dy=as.double(dy),                 
                  xg=double(nx),                 
                  yg=double(ny),                 
                  zg=double(nz),
                  varg=double(nz),
                  dog=as.integer(dog),
                  lon=as.double(point.obj$x),
                  lat=as.double(point.obj$y),
                  z=as.double(at),
                  extrap=as.integer(extrap),
                  n=as.integer(n),
                  covtype=as.integer(covtype),
                  covpar=as.double(var.mod.obj$parameters),
                  covmat=as.double(covmat),
                  ldcov=as.integer(n),
                  c0vec=double(n),
                  ldc0vec=as.integer(n),
                  c0=as.double(c0),
                  extcov=as.integer(0), # no external cov matrix
                  trend=as.integer(trend),
                  ntrend=as.integer(ntrend),
                  rsearch=as.double(rsearch),
                  nsearch=as.integer(nsearch),
                  nsmin=as.integer(nsmin),
                  nsmax=as.integer(nsmax),
                  fwork=double(n*ntrend),
                  ldfwrk=as.integer(n),
                  f0work=double(ntrend),
                  dist=double(n),
                  indsnb=integer(n),
                  indsna=integer(n),
                  indsrt=integer(n),
                  kwork=double((n+ntrend)*(n+ntrend)),
                  nkwork=as.integer(n+ntrend),
                  rhswork=double(n+ntrend),
                  ipiv=integer(n+ntrend),
                  mode=as.integer(mode),
                  mu=double(ntrend),
                  lambda=double(n),
                  ldlmbd=as.integer(n),
                  ierr=integer(1),
                  .Package="rgeostat")
    
#    ans<-krige.solve(s$x,s$y,point.obj$x,point.obj$y,
#                     at,covmat,c0vec,c0,trend,rsearch,nsmin,nsmax,mode)

    retval<-list(x=ans$xg,
                 y=ans$yg,
                 z=matrix(ans$zg,nx,ny),
                 var=matrix(ans$varg,nx,ny),
                 done=matrix(dog, nx, ny, byrow = F))
    retval$z[retval$done<=0] <- NA
    retval$var[retval$done<=0] <- NA
    retval    
  }

