krige.cell.pts <-  function (s,
                             point.obj,
                             at,
                             var.mod.obj,
                             maxdist = NULL,
                             extrap = F,
                             trend=0,
                             rsearch=0,
                             nsearch=0,
                             nsmin=-1,
                             nsmax=-1,
                             mode=1) 
{
  if (!inherits(s, "point")) 
    stop("s must be of class, \"point\".\n")
  if (!inherits(point.obj, "point")) 
    stop("point.obj must be of class, \"point\".\n")
  if (!inherits(var.mod.obj, "variogram.model")) 
    stop("var.mod.obj must be of class, \"variogram.model\".\n")
  s$do <- c(rep(1, length(s$x)))
  if (!extrap) {
    s$do <- in.convex.hull(tri.mesh(point.obj$x, point.obj$y, 
                                    duplicate = "remove"), s$x, s$y)*s$do
  }
  at <- point.obj[[match(at, names(point.obj))]]

  # krige.maxdist(s, point.obj, at, var.mod.obj, maxdist)
  n0 <- length(s$x)
  c0 <- var.mod.obj$parameters["X1"]+var.mod.obj$parameters["X2"]
  xy0.dist <- as.matrix(dist(rbind(cbind(s$x,s$y),
                                   cbind(point.obj$x,
                                         point.obj$y))
                             ,diag=T,upper=T))[-c(1:n0),c(1:n0)]
  c0vec <- c0-var.mod.obj$model(xy0.dist,var.mod.obj$parameters)
  xx.dist<-as.matrix(dist(cbind(point.obj$x,point.obj$y),
                          diag=T,upper=T))
  covmat <- c0-var.mod.obj$model(xx.dist,var.mod.obj$parameters)
  ans<-krige.solve(s$x,s$y,point.obj$x,point.obj$y,
                   at,covmat,c0vec,c0,trend,s$do,rsearch,nsearch,
                   nsmin,nsmax,mode)
  ans
}

krige.cell <-  function (x,
                         y,
                         point.obj,
                         at,
                         var.mod.obj,
                         maxdist = NULL,
                         extrap = F,
                         trend=0,
                         rsearch=0,
                         nsearch=0,
                         nsmin=-1,
                         nsmax=-1,
                         mode=1) 
{
  s<-data.frame(x=x,y=y)
  if (!inherits(point.obj, "point")) 
    stop("point.obj must be of class, \"point\".\n")
  if (!inherits(var.mod.obj, "variogram.model")) 
    stop("var.mod.obj must be of class, \"variogram.model\".\n")
  s$do <- c(rep(1, length(s$x)))
  if (!extrap) {
    s$do <- in.convex.hull(tri.mesh(point.obj$x, point.obj$y, 
                                    duplicate = "remove"), s$x, s$y)*s$do
  }
  at <- point.obj[[match(at, names(point.obj))]]

  # krige.maxdist(s, point.obj, at, var.mod.obj, maxdist)
  n0 <- length(s$x)
  c0 <- var.mod.obj$parameters["X1"]+var.mod.obj$parameters["X2"]
  xy0.dist <- as.matrix(dist(rbind(cbind(s$x,s$y),
                                   cbind(point.obj$x,
                                         point.obj$y))
                             ,diag=T,upper=T))[-c(1:n0),c(1:n0)]
  c0vec <- c0-var.mod.obj$model(xy0.dist,var.mod.obj$parameters)
  xx.dist<-as.matrix(dist(cbind(point.obj$x,point.obj$y),
                          diag=T,upper=T))
  covmat <- c0-var.mod.obj$model(xx.dist,var.mod.obj$parameters)
  ans<-krige.solve(s$x,s$y,point.obj$x,point.obj$y,
                   at,covmat,c0vec,c0,trend,s$do,rsearch,nsearch,
                   nsmin,nsmax,mode)
  ans
}

krige.solve <- function(x0,
                        y0,
                        x,
                        y,
                        z,
                        covmat,
                        c0vec,
                        c0,
                        trend=0,
                        do0=NULL,
                        rsearch=0,
                        nsearch=0,
                        nsmin=-1,
                        nsmax=-1,
                        mode=1)
  {
    n<-length(x)
    if(length(y)!=n) stop("length of x and y differ\n")
    n0<-length(x0)
    if(length(y0)!=n0) stop("length of x0 and y0 differ\n")
    if(is.null(do0)) do0<-rep(1,n0)
    if(length(do0)!=n0) stop("length of x0 and do0 differ\n")
    if(mode==1 && length(z)!=n) stop("length of x and z differ\n")
    if(dim(covmat)[1]!=n | dim(covmat)[2]!=n)
      stop("wrong dimension in covmat\n")
    if(is.vector(c0vec)) 
      if(length(c0vec)!=n) stop("wrong dimension in c0vec\n")
    if(is.matrix(c0vec)) 
      if(dim(c0vec)[1]!=n) stop("wrong dimension in c0vec\n")
    if(rsearch>0 & nsearch>0)
      stop("specify only one of rsearch and nsearch\n")
    if(nsmin>nsmax)
      stop("nsmin>nsmax\n")
#    if(rsearch>0){
#      if(nsmin==0) nsmin<-ceiling(n*0.1)
#      if(nsmax==0) nsmax<-ceiling(n*0.9)
#    }
    if(trend==0) ntrend<-1
    if(trend==1) ntrend<-3
    if(trend==2) ntrend<-6

    ans<-.Fortran("krige",
                  lon0=as.double(x0),
                  lat0=as.double(y0),
                  do0=as.integer(do0),
                  n0=as.integer(n0),
                  inddo=integer(n0),
                  lon=as.double(x),
                  lat=as.double(y),
                  z=as.double(z),
                  n=as.integer(n),
                  covtype=0,
                  covpar=double(3),
                  cov=as.double(covmat),
                  ldcov=as.integer(n),
                  c0vec=as.double(c0vec),
                  ldc0=as.integer(n),
                  c0=as.double(c0),
                  trend=as.integer(trend),
                  ntrend=as.integer(ntrend),
                  rsearch=as.double(rsearch),
                  nsearch=as.integer(nsearch),
                  nsmin=as.integer(nsmin),
                  nsmax=as.integer(nsmax),
                  fwork=double(n*ntrend),
                  ldfwrk=as.integer(n),
                  f0work=double(n0*ntrend),
                  ldf0wk=as.integer(ntrend),
                  dist=double(n),
                  indsnb=integer(n),
                  indsna=integer(n),
                  indsrt=integer(n),
                  kwork=double((n+ntrend)*(n+ntrend)),
                  nkwork=as.integer(n+ntrend),
                  rhswork=double(n0*(n+ntrend)),
                  ipiv=integer(n0*(n+ntrend)),
                  mode=as.integer(mode),
                  mu=double(n0*ntrend),
                  z0=double(n0),
                  lambda=double(n*n0),
                  ldlmbd=as.integer(n), 
                  var=double(n0),
                  ierr=integer(1)
             )
    if(mode==1)
      ret<-list(z0=ans$z0,
         lambda=matrix(ans$lambda,n,n0),
         var=ans$var,
         mu=matrix(ans$mu,ntrend,n0))
    if(mode==2)
      ret<-list(lambda=matrix(ans$lambda,n,n0),
         var=ans$var,
         mu=matrix(ans$mu,ntrend,n0))
    ret
  }
