"starplot" <-
function(x, full=T, radius=T, dots=F, scale=T, labels=T,
         byrow=T, bycol=F, rfactor=0.8, main=NULL, ...){
  if(bycol)
    byrow<-F
  
  if(!is.matrix(x) & !is.data.frame(x))
    stop("x is neither a matrix or a data frame!")

  if(full)
    fullangle<-2*pi
  else
    fullangle<-pi

  nobjs<-dim(x)[[1]]
  nvars<-dim(x)[[2]]
                                        # determine grid for output:
  n<-ceiling(sqrt(nobjs))
  dx<-dy<-1/n
  xpos<-seq(dx/2,1-dx/2,dx)
  ypos<-seq(1-dy/2,dy/2,-dy)


                                        # scale each column of x:
  if(scale){
    for (i in 1:nvars){
      cmin<-min(x[,i])
      if(cmin<0)
        x[,i]<-x[,i]-cmin
      cmax<-max(x[,i])
      if (cmax!=0)
        x[,i]<-x[,i]/cmax
    }
  }
  
  # create empty plot
  if(is.null(main))
     main<-paste("Starplot of", match.call()[2])
  plot.new()
  plot(c(0,0,1,1), c(0,1,0,1), type="n", xlab="", ylab="",
       xaxt="n", yaxt="n", ...)
  title(main)
  
  ir<-0
  ic<-0
  for (i in 1:nobjs){
    if(byrow){
      ir<-ceiling(i/n)
      ic<-i-(ir-1)*n
    }
    else{
      ic<-ceiling(i/n)
      ir<-i-(ic-1)*n
    }
    points(xpos[ic],ypos[ir])
    xrad<-rep(0,nvars+1)
    yrad<-rep(0,nvars+1)
    radius<-dx/2*rfactor
    for (j in 1:nvars){
     xrad[j]<-xpos[ic]+cos((j-1)*fullangle/nvars)*radius*x[i,j]
     yrad[j]<-ypos[ir]+sin((j-1)*fullangle/nvars)*radius*x[i,j]
    }
    xrad[nvars+1]<-xrad[1]
    yrad[nvars+1]<-yrad[1]

    lines(xrad,yrad)
    if(dots)
      points(xrad,yrad, pch=16)
    if(radius)
      for(j in 1:nvars)
        lines(c(xpos[ic], xrad[j]), c(ypos[ir], yrad[j]))
    if(labels)
      if(is.null(rownames(x)))
        text(xpos[ic], ypos[ir]-dx/2, as.character(i))
      else
        text(xpos[ic], ypos[ir]-dx/2, rownames(x)[i])
  }
  
}
