\name{dpik}
\title{Select a Bandwidth for Kernel Density Estimation}
\usage{dpik(x, scalest="minim", level=2, kernel="normal",
            canonical=F, gridsize=401, range.x=range(x),
            truncate=F)
}
\alias{dpik}
\arguments{
Required:
\item{x}{vector containing the sample on which the histogram is  to
       be constructed.}
Optional:
\item{scalest}{estimate of scale.

\code{"stdev"} - standard deviation is used.

\code{"iqr"}  - inter-quartile range divided by 1.349 is used.

\code{"minim"} - minimum of \code{"stdev"} and \code{"iqr"} is used.}
\item{level}{number of levels of functional  estimation  used  in  the
       plug-in rule.}
\item{kernel}{character string which determines the smoothing kernel.
       \code{kernel} can be:

\code{"normal"} - the Gaussian density function (the  default).

\code{"box"} - a rectangular box.

\code{"epanech"} - the centred beta(2,2) density.

\code{"biweight"} - the centred beta(3,3) density.

\code{"triweight"} - the centred beta(4,4) density.}
\item{canonical}{logical flag: if TRUE, canonically scaled kernels are
       used.}
\item{gridsize}{the number of equally spaced points at which to  esti
       mate the density.}
\item{range.x}{vector  containing the minimum and maximum values of x
       at which to compute the estimate.  The default is the min
       imum and maximum data values.}
\item{truncate}{logical flag: if TRUE, data with x values outside the
       range specified by range.x are ignored.}
}
\value{ the selected bandwidth.
}
\description{
       Use  direct plug-in methodology to select the bandwidth of
       a kernel density estimate.
}
\seealso{\code{\link{bkde}}, \code{\link{density}}
}
\examples{
data(faithful)
x <- faithful$eruptions
h <- dpik(x)
est <- bkde(x,bandwidth=h)
plot(est,type="l")
}
\references{
Sheather, S. J. and Jones, M. C. (1991).  A reliable data-based  bandwidth selection method for kernel density estimation.  Journal of the Royal Statistical Society,  Series B, 53, 683-690.

Wand,  M.  P.  and Jones, M. C. (1995).  Kernel Smoothing. Chapman and Hall, London.
}
