"dpill" <-
function (x, y, blockmax = 5, divisor = 20, trim = 0.01, proptrun = 0.05, 
        gridsize = 401, range.x = range(x), truncate = T) 
{
        # Trim the 100(trim)% of the data from each end (in the x-direction).
        xy <- cbind(x, y)
        xy <- xy[sort.list(xy[, 1]), ]
        x <- xy[, 1]
        y <- xy[, 2]
        indlow <- floor(trim * length(x)) + 1
        indupp <- length(x) - floor(trim * length(x))
        x <- x[indlow:indupp]
        y <- y[indlow:indupp]
        # Rename common parameters
        n <- length(x)
        M <- gridsize
        a <- range.x[1]
        b <- range.x[2]
        delta <- (b - a)/(M - 1)
        # Bin the data 
        gpoints <- seq(a, b, length = M)
        out <- rlbin(x, y, gpoints, truncate)
        xcounts <- out$xcounts
        ycounts <- out$ycounts
        # Choose the value of N using Mallow's C_p
        Nmax <- max(min(floor(n/divisor), blockmax), 1)
        Nval <- cpblock(x, y, Nmax, 4)
        # Estimate sig^2, theta_22 and theta_24 using quartic fits 
        # on "Nval" blocks.
        out <- blkest(x, y, Nval, 4)
        sigsqQ <- out$sigsqe
        th22Q <- out$th22e
        th24Q <- out$th24e
        # Estimate theta_22 using a local cubic fit
        # with a "rule-of-thumb" bandwidth: "gamseh"
        gamseh <- (sigsqQ * (b - a)/(abs(th24Q) * n))
        if (th24Q < 0) 
                gamseh <- (3 * gamseh/(8 * sqrt(pi)))^(1/7)
        if (th24Q > 0) 
                gamseh <- (15 * gamseh/(16 * sqrt(pi)))^(1/7)
        mddest <- locpoly(xcounts, ycounts, drv = 2, bandwidth = gamseh, 
                range.x = range.x, binned = T)$y
        llow <- floor(proptrun * M) + 1
        lupp <- M - floor(proptrun * M)
        th22kn <- sum((mddest[llow:lupp]^2) * xcounts[llow:lupp])/n
        # Estimate sigma^2 using a local linear fit
        # with a "direct plug-in" bandwidth: "lamseh"
        C3K <- (1/2) + 2 * sqrt(2) - (4/3) * sqrt(3)
        C3K <- (4 * C3K/(sqrt(2 * pi)))^(1/9)
        lamseh <- C3K * (((sigsqQ^2) * (b - a)/((th22kn * n)^2))^(1/9))
        # Now compute a local linear kernel estimate of
        # the variance.
        mest <- locpoly(xcounts, ycounts, bandwidth = lamseh, 
                range.x = range.x, binned = T)$y
        Sdg <- sdiag(xcounts, bandwidth = lamseh, range.x = range.x, 
                binned = T)$y
        SSTdg <- sstdiag(xcounts, bandwidth = lamseh, range.x = range.x, 
                binned = T)$y
        sigsqn <- sum(y^2) - 2 * sum(mest * ycounts) + sum((mest^2) * 
                xcounts)
        sigsqd <- n - 2 * sum(Sdg * xcounts) + sum(SSTdg * xcounts)
        sigsqkn <- sigsqn/sigsqd
        # Combine to obtain final answer.
        hhat <- (sigsqkn * (b - a)/(2 * sqrt(pi) * th22kn * n))^(1/5)
        return(hhat)
}
