/* C-PROGRAM FOR KERNEL REGRESSION				*/
/* INTERFACE : x,y vectors of data				*/
/* h = bandwidth of the kernel estimation			*/
/* grid = vector with gridpoints				*/
/* fh = vector with estimates					*/
/* rh = vector with ??						*/
/* mh = vector with ??						*/
/* n = number of observations					*/
/* gridpoints = number of gridpoints where the			*/
/* estimation should be calculated				*/
/* kernel = number of kerneltype between 1 and 7		*/
/* 1 = Uniform, 2 = Triangle,					*/
/* 3 = Epanechnikov, 4 = Quartic,				*/
/* 5 = Triweight, 6 = Gaussian,					*/
/* 7 = Cosinus							*/
/* rangex = minimum and maximum of data				*/
/* fh0 how to handle case rh/fh=0/0 (default missing value)	*/

#include<stdio.h>
#include<math.h>
#define PI 3.14159265

double kernel1 (u)
double u;
{
  return(0.5);
}

double kernel2 (u)
double u;
{
  double w;
  w = 1-fabs(u);
  return(w);
}

double kernel3 (u)
double u;
{
  double w;
  w = 0.75 *(1-u*u);
  return(w);
}

double kernel4 (u)
double u;
{
  double w1, w2;
  w2 = 1-u*u;
  w1 = 0.9375 *w2 * w2;
  return(w1);
}

double kernel5 (u)
double u;
{
  double w1, w2;
  w2=1-u*u;
  w1 = 1.09375 *w2*w2*w2;
  return(w1);
}

double kernel6 (u)
double u;
{
  double w;
  w = (1.0/pow(2.0*PI,0.5))*exp(-0.5 *u*u);
  return(w);
}

double kernel7 (u)
double u;
{
  double w;
  w = PI / 4.0*cos(PI/2.0 * u);
  return(w);
}


kernelregression(x,y,h,grid,fh,rh,mh,n,gridpoints,kernel,rangex,fh0)
double *x,*y,*grid,*fh,*rh,*mh,*h,*rangex;
long *n,*kernel,*gridpoints,*fh0;
{
  double gridmin,gridstep,weight,distance,estimate;
  long k1,k2;
  long register i,j;
  double (*kernelproc)();
  gridmin=rangex[0]-h[0];
  gridstep=(rangex[1]+h[0]-gridmin)/(double)(gridpoints[0]-1);
  for (i=0;i<gridpoints[0];i++)
    grid[i]=gridmin+gridstep*(double)i;
  switch (kernel[0])
  {
    case 1 :  kernelproc = kernel1; break;
    case 2 :  kernelproc = kernel2; break;
    case 3 :  kernelproc = kernel3; break;
    case 4 :  kernelproc = kernel4; break;
    case 5 :  kernelproc = kernel5; break;
    case 6 :  kernelproc = kernel6; break;
    case 7 :  kernelproc = kernel7; break;
    default:  printf(" Error in the choice of kernel"); return;
  }
  if(kernel[0]!=6)
/* If the kernel is not Gaussian, i.e. has support [-1,1]	*/
  {
    for (i=0;i<n[0];i++)
    {
      k1=floor((x[i]-grid[0]-h[0])/gridstep)+1;
      k2=floor((x[i]-grid[0]+h[0])/gridstep);
      for (j=k1;j<(k2+1);j++)
      {
        distance=(x[i]-grid[j])/h[0];
        weight=(*kernelproc)(distance);
        rh[j]+=weight*y[i];
        fh[j]+=weight;
      } 
    } 
  }
  else 
  {
    for(i=0;i<n[0];i++)
    {
      for(j=0;j<gridpoints[0];j++)
      {
        distance=(x[i]-grid[j])/h[0];
        weight=(*kernelproc)(distance);
        rh[j]+=weight*y[i];
        fh[j]+=weight;
      }
    }
  }
  if((*fh0)==1)
  {
/* Estimate is 0, if fh[j]=0 and flag (*fh0) is set to 1	*/
    for(j=0;j<gridpoints[0];j++)
    {
      if(fh[j]==0)
        mh[j]=0;
      else
        mh[j]=rh[j]/fh[j];
    }
  }
  else
  {
    for(j=0;j<gridpoints[0];j++)
      mh[j]=rh[j]/fh[j];
  }
  return(0);
} /* end */

  
