\name{ortho.series0.1}
\title{Orthogonal series estimator on [0,1]}
\usage{ortho.series0.1(data, N)
}
\alias{ortho.series0.1}
\arguments{
\item{data}{data vector}
\item{N}{number of terms of series to be included}
}
\value{
       matrix with two columns of a grid of  101  point  and  the
       density estimates.
}
\description{       Orthogonal series estimator on [0,1] using sine-cosine series
}
\examples{
data(dat.mixed)
# Figure 3.1
zoom <- dat.mixed[abs(dat.mixed-0.5)<=0.5]
plot(ortho.series0.1(zoom,9), type="l")
lines(ortho.series0.1(zoom,2), lty=3)
grid<-c(0:50)/50
true.density <- (0.6*exp(-0.5*(grid+1)^2) + 0.4*exp(-0.5*(grid-2)^2))/sqr
t(2.0*pi)
true.density <- 50*true.density/sum(true.density)
density.mixed<-matrix(c(grid,true.density), length(grid), 2)
lines(density.mixed, lty=2)

# Exercise 3.2
data <- runif(100)^2
par(mfrow=c(2,2))
plot(ortho.series0.1(data,2), ylim=c(0,4), xlab="", ylab="", type="l")
plot(ortho.series0.1(data,7), ylim=c(0,4), xlab="", ylab="", type="l")
plot(ortho.series0.1(data,20), ylim=c(0,4), xlab="", ylab="", type="l")
histogram(data,h=0.1,0,TRUE)
}
\references{`Smoothing Techniques with Implementation in S', Wolfgang Haerdle,
Springer, 1991
}
