\name{Simul.conf.plot}
\title{plot simultaneous confidence intervals for WARPing regression}
\usage{Simul.conf.plot(x, y, h, alpha=0.2, N=200)
}
\alias{Simul.conf.plot}
\arguments{Required:
\item{x}{predictor}
\item{y}{response}
\item{h}{bandwidth}
Optional:
\item{alpha}{1 - confidence coefficient}
\item{N}{number of bootstrap samples}
}
\value{None
}
\description{       plot simultaneous confidence intervals for WARPing regres
       sion via the golden section bootstrap
}
\seealso{\code{\link{Simul.conf.interval}}}
)
\examples{
data(faithful)
# Figures 7.3-7.5
Simul.conf.plot(faithful$eruptions, faithful$waiting, h=0.65)
Simul.conf.plot(faithful$eruptions, faithful$waiting, h=0.4)

data(dat.reg)
# Figures 7.6-7.8
Simul.conf.plot(dat.reg$x, dat.reg$y, h=0.065)
lines(dat.reg$x, dat.reg$m)
Simul.conf.plot(dat.reg$x, dat.reg$y, h=0.0225)
lines(dat.reg$x, dat.reg$m)
Simul.conf.plot(dat.reg$x, dat.reg$y, h=0.1)
lines(dat.reg$x, dat.reg$m)
}
\references{`Smoothing Techniques with Implementation in S', Wolfgang Haerdle,
Springer, 1991
}
