Simul.conf.interval<-function(x,y,h,alpha=0.2,N=200)
{
  locationnumber<-floor(diff(range(x))/h*11/3)-1
  locations<-min(x)+c(1:locationnumber)*3*h/11
  limits<-matrix(0,locationnumber,2)
  Bootstrap<-GS.Warping(x,y,h,locations,samplenumber=N,M=11,M.large=22)
  G<-ceiling(locationnumber/7)
  alpha.G<-alpha/G
  for(j in 1:(G-1))
  {
    group<-Bootstrap$mMstar[,(1+(j-1)*7):(j*7)]
    limits[(1+(j-1)*7):(j*7),]<-Within.group(group,alpha.G)
  }
  lastgroup<-locationnumber-(G-1)*7
  group<-matrix(Bootstrap$mMstar[,(1+(G-1)*7):locationnumber],N,lastgroup)
  limits[(1+(G-1)*7):locationnumber,]<-Within.group(group,alpha.G)
  conf.limits<-limits-Bootstrap$mM.large+Bootstrap$mM
  list(locations=Bootstrap$locations,
    lower.limit=conf.limits[,1],
    upper.limit=conf.limits[,2],
    m=Bootstrap$mM)
}

Within.group<-function(data,beta)
{
  N<-dim(data)[1]
  L<-dim(data)[2]
  order.data<-matrix(0,N,L)
# Compute the ranks of the observations for each location
  for (k in 1:L)
  {
    order.data[,k]<-order(data[,k])
  }
  niveau<-0
  i<-1
  lower.limit<-rep(0,L)
  lower.limit.lower<-rep(0,L)
  lower.limit.upper<-rep(0,L)
  upper.limit<-rep(0,L) 
  upper.limit.lower<-rep(0,L)
  upper.limit.upper<-rep(0,L)
  diff.size<-rep(0,N)
# The N elememts of diff.size correspond to N samples and are
# initially set to 0.  When a sample contains observations outside
# the confidence limits, the corresponding element of diff.size
# is set to 1 using the vector of ranks, which contains exactly
# the information, which sample contains the i-th largest and
# smallest observation.
  while(niveau<beta)
  {
    i<-i+1
# Suppose conf.limits as the i-th and (N-i+1)-th order statistic.
    diff.size[order.data[i-1,]]<-1
    diff.size[order.data[N-i+2,]]<-1
# Then the (i-1)-th and (N-i+2) order statistics lie outside
# these confidence limits.
    alpha.upper<-niveau
    niveau<-sum(diff.size)/N
# Save the old niveau as alpha.upper and compute new niveau.
# If niveau too small take next order statistics.
  }
  for(k in 1 : L)
  {
    lower.limit.upper[k]<-data[order.data[i-1,k],k]
    upper.limit.upper[k]<-data[order.data[N-i+2,k],k]
# Identify confidence limits for the upper niveau with the
# (i-1)-th and (N-i+2)-th order statistics.
  lower.limit.lower[k]<-data[order.data[i,k],k]
  upper.limit.lower[k]<-data[order.data[N-i+1,k],k]
# Identify confidence limits for the lower niveau with the
# i-th and (N-i+1)-th order statistics.
  }
  alpha.lower<-niveau
  upper.weight<-(alpha.lower-beta)/(alpha.lower-alpha.upper)
  lower.weight<-1-upper.weight
# Compute the weights of the confidence limits.
  for(k in 1 : L)
  {
    upper.limit[k]<-lower.weight*upper.limit.lower[k] +
    	upper.weight*upper.limit.upper[k]
    lower.limit[k]<-lower.weight*lower.limit.lower[k] +
   	 upper.weight*lower.limit.upper[k]
# Weight the confidence limits.
  }
  interval<-matrix(c(lower.limit,upper.limit),L,2)
  interval
}

Simul.conf.plot<-function(x,y,h,alpha=0.2,N=200)
{
  z<- Simul.conf.interval(x,y,h,alpha,N=N)
  yli<-c(min(z$lower.limit),max(z$upper.limit))
  plot(z$locations,z$m,type="l",cex=0.6,xlab="",ylab="",ylim=yli)
  lines(z$locations,z$lower.limit,lty=2)
  lines(z$locations,z$upper.limit,lty=2)
}
