"NW.kernel" <-
function (x, y, h, kernel = 4, points = 100, na.handling = 0) 
{
        help <- (is.na(x) | is.na(y))
        x <- x[!help]
        y <- y[!help]
        n <- length(x)
        result <- .C("kernelregression", as.double(x), as.double(y), 
                as.double(h), double(points), double(points), 
                double(points), double(points), as.integer(n), 
                as.integer(points), as.integer(kernel), as.double(range(x)), 
                as.integer(na.handling))
        indexrange <- ((result[[4]] - min(x)) * (max(x) - result[[4]]) >= 
                0)
        result.list <- list(grid = result[[4]][indexrange], m = result[[7]][indexrange], 
                x = x, y = y)
        result.list
}
