kds.ci<-function(data,h,g,x,alpha)
{
  data<-data[!is.na(data)]
  n<-length(data)
  x<-x[!is.na(x)]
  nx<-length(x)
  n<-length(data)
  result<- .C("kerneldensityci",
    as.double(data),
    as.integer(n),
    as.double(h),
    as.double(g),
    double(nx),
    double(nx),
    as.double(x),
    as.integer(nx))
  alpha.simult<-(1-alpha/2)^(1/nx)
# change of confidence level, when we compute a set of intervals
  u.a.s<-qnorm(alpha.simult)
# corresponding quantile of standard normal distribution
  c.h<-h*n^.2
  bias.est<-c.h^2*result[[6]]/2
  var.est<-result[[5]]/(2*sqrt(pi)*c.h)
  ci.lower<-result[[5]]-n^(-0.4)*(bias.est+u.a.s*sqrt(var.est))
  ci.upper<-result[[5]]-n^(-0.4)*(bias.est-u.a.s*sqrt(var.est))
  final.result<-matrix(c(x,result[[5]],result[[6]],
    ci.lower, ci.upper),nx,5)
  final.result
}
