histogram<-function(data,h,x0,plot.type=T,...)
{
  data<-data[!is.na(data)]
  n<-length(data)
  first<-floor((min(data)-x0)/h)
  last<-ceiling((max(data)-x0)/h)
  binmesh<-x0+h*c(first:last)
  counts<-hist(data,breaks=binmesh,plot=FALSE)$counts
#  counts <- .C("bincount", as.double(data), length(data), 
#	       as.double(binmesh),length(binmesh),
#	       counts = integer(length(binmesh) - 1), TRUE)[[5]]
#FALSE replaces "n", second counts has the s missing in book 
  est<-counts /(n*h)
  if(plot.type==TRUE)
  {
    hist(data,breaks=binmesh,yaxt="n",cex=0.8,xlab="",bar.stlye="old",freq=F,...)
    maxheight <-max(counts)
    print(maxheight)
    ymarks<- c(0:4) / 4 * maxheight
    ymarkslabels <-round(ymarks/(n*h),digits=3)
    box()
    axis(2,at=ymarks,labels=ymarkslabels,srt=90,cex=0.8)
  }
  else
  {
    midpoints<-x0+h*c((first-0.5):(last+0.5))
    est<-c(0,est,0)
    result <-list(midpoints,est)
    result
  }
}


frequency.polygon <- function(data,h,x0)
{
  est <- histogram(data,h,x0,FALSE)
  plot(est[[1]], est[[2]], type="l", xlab="", ylab="", cex=0.8)
}

histogram.normal.ref <- function(data,x0,plot.type=T)
{
  data <- data[!is.na(data)]
  n <- length(data)
  s <- sqrt(var(data))
  h <- 3.491*s*n^(-1/3)
  histogram(data,h,x0,plot.type)
}
