kdesign.cov <- function(point.obj,eligible.obj=NULL,var.mod.obj)
{
  
  if (!inherits(point.obj, "point")) 
    stop("point.obj must be of class, \"point\".\n")

  if (!inherits(var.mod.obj, "variogram.model")) 
    stop("var.mod.obj must be of class, \"variogram.model\".\n")

  if (!is.null(eligible.obj))
    P.dist <- as.matrix(dist(rbind(point.obj[,c("x","y")],
                             eligible.obj[,c("x","y")]),diag=T,upper=T))
  else
    P.dist <- as.matrix(dist(point.obj[,c("x","y")],diag=T,upper=T))

  A.cov <- var.mod.obj$model(P.dist,var.mod.obj$parameters)
  C0.cov <- var.mod.obj$parameters[1]+var.mod.obj$parameters[2]
  covmat <- C0.cov-A.cov

  covmat
}

