kdesign <- function(algorithm="greedy",
                       point.obj,
                       eligible.obj,
                       ns,
                       at,
                       var.mod.obj,
                       xsw=NULL,ysw=NULL,xne=NULL,yne=NULL,
                       dx=NULL,dy=NULL,
                       angle=NULL,
                       maxdist = NULL,
                       extrap = F,
                       border=NULL,
                       trend=0,
                       rsearch=0,
                       nsearch=0,
                       nsmin=-1,
                       nsmax=-1,
                       pgrid=1,
                       criterion="meanvar",
                       verbose=F)
  {
    testalgorithm <- switch(algorithm, greedy="ok",dualgreedy="ok",
                         cenum="ok","error")
    if(testalgorithm=="error")
      stop("wrong argument for \"algorithm\", should be one of \"greedy\", \"dualgreedy\",\"cenum\"!")
    
    testcriterion <- switch(criterion, meanvar="ok",maxvar="ok","error")
    if(testcriterion=="error")
      stop("wrong argument for \"criterion\", should be one of \"meanvar\", \"maxvar\"!")
    
    switch(algorithm,
           greedy = kdesign.greedy( 
                       point.obj,
                       eligible.obj,
                       ns,
                       at,
                       var.mod.obj,
                       xsw,ysw,xne,yne,
                       dx,dy,
                       angle,
                       maxdist,
                       extrap,
                       border,
                       trend,
                       rsearch,
                       nsearch,
                       nsmin,
                       nsmax,
                       pgrid,
                       criterion,
                       verbose),
           dualgreedy = kdesign.dualgreedy(
                       point.obj,
                       eligible.obj,
                       ns,
                       at,
                       var.mod.obj,
                       xsw,ysw,xne,yne,
                       dx,dy,
                       angle,
                       maxdist,
                       extrap,
                       border,
                       trend,
                       rsearch,
                       nsearch,
                       nsmin,
                       nsmax,
                       pgrid,
                       criterion,
                       verbose),
           cenum = kdesign.cenum(
                       point.obj,
                       eligible.obj,
                       ns,
                       at,
                       var.mod.obj,
                       xsw,ysw,xne,yne,
                       dx,dy,
                       angle,
                       maxdist,
                       extrap,
                       border,
                       trend,
                       rsearch,
                       nsearch,
                       nsmin,
                       nsmax,
                       pgrid,
                       criterion=criterion,
                       verbose))
  }

