bkdesign.greedy <- function(point.obj,
                      eligible.obj,
                      ns,
                      at,
                            prior,
                      var.mod.obj,
                      xsw=NULL,ysw=NULL,xne=NULL,yne=NULL,
                      dx=NULL,dy=NULL,
                      angle=NULL,
                      maxdist = NULL,
                      extrap = FALSE,
                     border=NULL,
                      trend=0,
                      rsearch=0,
                      nsearch=0,
                      nsmin=-1,
                      nsmax=-1,
                      pgrid=1,
                            verbose=FALSE,
                      criterion="meanvar",
                            method="gqr")
  {


    lcbind<-function(lst){
      nmat<-length(lst); ret<-NULL;
      for(i in 1:nmat) ret<-cbind(ret,lst[[i]])
      ret
    }

    verbose<-verbose*1
    extcov<-1
    mode<-2
    if(is.null(angle)) angle<-0
    if(pgrid==1)
      {
        if(is.null(xsw)) xsw<-min(point.obj$x,eligible.obj$x)
        if(is.null(xne)) xne<-max(point.obj$x,eligible.obj$x)
        if(is.null(ysw)) ysw<-min(point.obj$y,eligible.obj$y)
        if(is.null(yne)) yne<-max(point.obj$y,eligible.obj$y)
      }
    if(pgrid==2)
      {
        if(is.null(xsw)) xsw<-min(eligible.obj$x)
        if(is.null(xne)) xne<-max(eligible.obj$x)
        if(is.null(ysw)) ysw<-min(eligible.obj$y)
        if(is.null(yne)) yne<-max(eligible.obj$y)
      }

    testcriterion <- switch(criterion, meanvar="ok",maxvar="ok","error")
    if(testcriterion=="error")
      stop("wrong argument for \"criterion\", should be one of \"meanvar\", \"maxvar\"!")

    dgx <- xne-xsw
    dgy <- yne-ysw

    if(is.null(dx)) dx <- dgx/20
    if(is.null(dy)) dy <- dgy/20

    nx <- ceiling(dgx/dx)+1
    ny <- ceiling(dgy/dy)+1
    
    at <- point.obj[[match(at, names(point.obj))]]
    nf <- length(point.obj$x)
    ne <- length(eligible.obj$x)
    n <- nf+ne

    nz <- nx * ny
    
    dog <- matrix(1, nx, ny)
    if (!extrap) {
      if(pgrid==1)
        {
          tmpgrd <- cbind(rep(seq(xsw,xne,length=nx),ny),
                          sort(rep(seq(ysw,yne,length=ny),nx)))
          dog <- in.chull(tmpgrd[,1], tmpgrd[,2],
                          c(point.obj$x,eligible.obj$x),
                          c(point.obj$y,eligible.obj$y))
        }
      if(pgrid==2)
        {
          tmpgrd <- cbind(rep(seq(xsw,xne,length=nx),ny),
                          sort(rep(seq(ysw,yne,length=ny),nx)))
          dog <- in.chull(tmpgrd[,1], tmpgrd[,2],
                          eligible.obj$x,eligible.obj$y)
        }
     if(!is.null(border)){
     dog2 <- in.polygon(tmpgrd[,1], tmpgrd[,2],
                        border$x,border$y)
     dog <- dog & dog2
     }
      # workaround for int <-> unsigned int problem on alpha platform:
      dog <- abs(as.numeric(dog))
      dog <- matrix(dog, nx, ny,byrow=FALSE)
    }
    
    extrap<-as.integer(1*extrap)
    
    if (!inherits(point.obj, "point")) 
      stop("point.obj must be of class, \"point\".\n")
    if (!inherits(var.mod.obj, "variogram.model")) 
      stop("var.mod.obj must be of class, \"variogram.model\".\n")
    if(rsearch>0 & nsearch>0)
      stop("specify only one of rsearch and nsearch\n")
    if(nsmin>nsmax)
      stop("nsmin>nsmax\n")
#    if(rsearch>0){
#      if(nsmin==0) nsmin<-ceiling(n*0.1)
#      if(nsmax==0) nsmax<-ceiling(n*0.9)
#    }
    if(trend==0) ntrend<-1
    if(trend==1) ntrend<-3
    if(trend==2) ntrend<-6

    covtype<-switch(attr(var.mod.obj,"type"),
                    exponential=1,
                    gaussian=2,
                    spherical=3,
                    linear=4,
                    0)

    cov0<-0
    covmat<-matrix(0,n,n)

    #browser()
    if(extcov==1)
      {
        P.dist <- as.matrix(dist(rbind(point.obj[,c("x","y")],
                               eligible.obj[,c("x","y")]),diag=TRUE,upper=TRUE))
        A.cov <- var.mod.obj$model(P.dist,var.mod.obj$parameters)
        if(is.na(var.mod.obj$parameters["sill"]))
        C0.cov <- var.mod.obj$parameters["X1"]+var.mod.obj$parameters["X2"]
        else
        C0.cov <- var.mod.obj$parameters["nugget"]+var.mod.obj$parameters["sill"]
        covmat <- C0.cov-A.cov
    }

#   determine optimum array sizes:
    if(!is.null(method)){
      if(method!="gqr" && method!="direct" && method!="ols")
        stop("method (used for glsfit) should be one of \"gqr\", \"ols\" or \"direct\"!")
    } else {
      method <-"gqr"
    }
    method<-switch(method,direct=2,gqr=1,ols=0)
    
    lwork <- glsfit.workquery(n,ntrend,method)

    npr<-prior$n
    typpr<-prior$info
    typpr[prior$type=="subjective"]<-typpr[prior$type=="subjective"]*(-1)

# prepare concatenated fortran arguments to avoid 65 parameter limit:    
#     DATVEC=XSW+YSW+XNE+YNE+ANGLE+DX+DY+LON+LAT+Z
#     length= 1   1   1   1   1     1  1  N   N  N
##    datvec<-c(xsw,ysw,xne,yne,angle,dx,dy,point.obj$x,point.obj$y,at)
    
#     DBLVEC=XG+YG+ muwrk  beta errbeta dev errdev zsrnb dist work ferr berr
#     length=NX+NY+ ntrend+ntrend  +1    +n   +1    +n    +n +lwork +n   +n    
##    dblvec<-double(nx+ny+ntrend+ntrend+1+n+1+n+n+lwork+n+n)

#     INTVEC=NX NY NZ EXTRAP N COVTYPE TREND NTREND NPR TYPPR NSEARCH NSMIN 
#     length= 1  1  1    1   1    1      1      1    1   npr     1     1 
#            NSMAX INDSNB INDSNW INDSRT LWORK IPVT    IPIV   IWORK MODE GLSMTH
#       ...   1      n       n      n     1  ntrend n+ntrend  3*n   1     1
#       ...  BITS
#       ...  nz+nz*n+1 (pos nz+1=usesnbbit)
##    intvec<-c(nx,ny,nz,extrap,n,covtype,trend,ntrend,npr,typpr,nsearch,nsmin,
##              nsmax,integer(n),integer(n),integer(n),lwork,integer(ntrend),
##              integer(n+ntrend),integer(3*n),mode,method,
##              as.integer(c(integer(nz),as.integer(0),integer(n*nz))))

    if(criterion=="maxvar")
      {
        ans<-.Fortran("bkgrmx",
                      nf      = as.integer(nf),
                      ne      = as.integer(ne),
                      ns      = as.integer(ns),
                      S       = integer(ne),
                      opt     = double(1),
                      ind     = integer(n),
                      covsel  = double(n*n),
                      ldcvsl  = as.integer(n),
                      lonsel  = double(n),
                      latsel  = double(n),
                      verb    = as.integer(verbose),
                      xsw     = as.double(xsw),
                      ysw     = as.double(ysw),
                      xne     = as.double(xne),
                      yne     = as.double(yne),
                      angle   = as.double(angle),
                      nx      = as.integer(nx),
                      ny      = as.integer(ny),
                      dx      = as.double(dx),
                      dy      = as.double(dy),
                      xg      = double(nx),
                      yg      = double(ny),
                      zg      = double(nz),
                      ldzg    = as.integer(nx),
                      varg    = double(nz),
                      ldvarg  = as.integer(nx),
                      dog     = as.integer(dog),
                      lddog   = as.integer(nx),
                      lon     = as.double(c(point.obj$x,eligible.obj$x)),
                      lat     = as.double(c(point.obj$y,eligible.obj$y)),
                      z       = double(n),
                      extrap  = as.integer(extrap),
                      n       = as.integer(n),
                      covtype = as.integer(covtype),
                      covpar  = as.double(var.mod.obj$parameters),
                      covmat  = as.double(covmat),
                      ldcov   = as.integer(n),
                      c0vec   = double(n),
                      cov0    = as.double(cov0),
                      extcov  = as.integer(extcov),
                      trend   = as.integer(trend),
                      ntrend  = as.integer(ntrend),
                      mupr    = as.double(lcbind(prior$mu)),
                      ldmpr   = as.integer(ntrend),
                      phipr   = as.double(lcbind(prior$phi)),
                      ldphpr  = as.integer(ntrend),
                      lonpr   = as.double(prior$lon),
                      latpr   = as.double(prior$lat),
                      npr     = as.integer(npr),
                      typpr   = as.integer(typpr),
                      rsearch = as.double(rsearch),
                      nsearch = as.integer(nsearch),
                      nsmin   = as.integer(nsmin),
                      nsmax   = as.integer(nsmax),
                      lwork   = as.integer(lwork),
                      mode    = as.integer(mode),
                      mu      = double(ntrend),
                      lambda  = double(n),
                      lambd0  = double(1),
                      ierr    = integer(1),
                      glsmth  = as.integer(method))
      }
    else
      {
        #browser()
        ans<-.Fortran("bkgrmn",
                      nf      = as.integer(nf),
                      ne      = as.integer(ne),
                      ns      = as.integer(ns),
                      S       = integer(ne),
                      opt     = double(1),
                      ind     = integer(n),
                      covsel  = double(n*n),
                      ldcvsl  = as.integer(n),
                      lonsel  = double(n),
                      latsel  = double(n),
                      verb    = as.integer(verbose),
                      xsw     = as.double(xsw),
                      ysw     = as.double(ysw),
                      xne     = as.double(xne),
                      yne     = as.double(yne),
                      angle   = as.double(angle),
                      nx      = as.integer(nx),
                      ny      = as.integer(ny),
                      dx      = as.double(dx),
                      dy      = as.double(dy),
                      xg      = double(nx),
                      yg      = double(ny),
                      zg      = double(nz),
                      ldzg    = as.integer(nx),
                      varg    = double(nz),
                      ldvarg  = as.integer(nx),
                      dog     = as.integer(dog),
                      lddog   = as.integer(nx),
                      lon     = as.double(c(point.obj$x,eligible.obj$x)),
                      lat     = as.double(c(point.obj$y,eligible.obj$y)),
                      z       = double(n),
                      extrap  = as.integer(extrap),
                      n       = as.integer(n),
                      covtype = as.integer(covtype),
                      covpar  = as.double(var.mod.obj$parameters),
                      covmat  = as.double(covmat),
                      ldcov   = as.integer(n),
                      c0vec   = double(n),
                      cov0    = as.double(cov0),
                      extcov  = as.integer(extcov),
                      trend   = as.integer(trend),
                      ntrend  = as.integer(ntrend),
                      mupr    = as.double(lcbind(prior$mu)),
                      ldmpr   = as.integer(ntrend),
                      phipr   = as.double(lcbind(prior$phi)),
                      ldphpr  = as.integer(ntrend),
                      lonpr   = as.double(prior$lon),
                      latpr   = as.double(prior$lat),
                      npr     = as.integer(npr),
                      typpr   = as.integer(typpr),
                      rsearch = as.double(rsearch),
                      nsearch = as.integer(nsearch),
                      nsmin   = as.integer(nsmin),
                      nsmax   = as.integer(nsmax),
                      lwork   = as.integer(lwork),
                      mode    = as.integer(mode),
                      mu      = double(ntrend),
                      lambda  = double(n),
                      lambd0  = double(1),
                      ierr    = integer(1),
                      glsmth  = as.integer(method))
      }

    retval<-list(x=ans$dblvec[1:nx],
                 y=ans$dblvec[(nx+1):(nx+ny)],
                 var=matrix(ans$varg,nx,ny),
                 S=ans$S,
                 opt=ans$opt)

    retval$var[ans$dog==0] <- NA
    retval    
  }

