"surface.surface"<-
function(obj, lab = NA, type = "b", zlab, xlab, ylab, graphics.reset = F, ...)
{
	old.par <- par("mfrow", "oma")
	if(graphics.reset) {
		on.exit(par(old.par))
		par(xpd = T)
	}
	if(is.null(obj$xlab))
		obj$xlab <- "X"
	if(is.null(obj$ylab))
		obj$ylab <- "Y"
	if(missing(zlab)) {
		zlab <- "Z"
	}
	if(!missing(xlab)) {
		obj$xlab <- xlab
	}
	if(!missing(ylab)) {
		obj$xlab <- ylab
	}
	if(is.na(lab) & !is.null(obj$main)) {
#		lab <- paste("Fixed Variables:  ", obj$main)
		lab <- obj$main
	}
	if(type == "b") set.panel(2, 1, T)	#
#perspcetive plot
#
	if(type == "p" | type == "b") {
		persp(obj, xlab = obj$xlab, ylab = obj$ylab, zlab = zlab, ...)
		if(!is.na(lab)) {
			title(lab)
		}
	}
#
#contour plot
#
	if(type == "c" | type == "b") {
		contour(obj, xlab = obj$xlab, ylab = obj$ylab, ...)
		if(!is.na(lab) & type != "b") {
			title(lab)
		}
	}
#
#image plot with legend
#
	if(type == "i" | type == "I") {
		image.plot(obj, xlab = obj$xlab, ylab = obj$ylab, ...)
		if(!is.na(lab) & type != "b") {
			title(lab)
		}
		if(type == "I") {
			contour(obj, add = T)
		}
	}
	invisible()
}
