"ptab"<-
function(terms, data)
{
## take a terms object and make a ptab object
## as used by tps and created by make.Tmatrix
## this just works for quadratic type functions now
	x.names <- dimnames(data)[[2]]
	term.labels <- attr(terms, "term.labels")
	factors <- attr(terms, "factors")
	n.x <- length(x.names)
	n.terms <- ncol(factors)
	int <- attr(terms, "intercept")
	ptab <- t(factors[1:n.x,  ])
	term.names <- dimnames(ptab)[[1]]
	for(i in 1:n.terms) {
		c.terms <- charmatch(paste("I(", x.names, "^2)", sep = ""), 
			term.names[i], nomatch = 0)
		ptab[i,  ] <- ptab[i,  ] + 2 * (c.terms >= 1)
	}
	if(int)
		ptab <- rbind(Intercept = rep(0, n.x), ptab)
	ptab
}
