"make.Mmatrix.tps"<-
function(out, x0 = out$x, lambda)
{
	if(missing(lambda)) {
		lambda <- out$lambda
	}
	xc <- out$transform$x.center
	xs <- out$transform$x.scale
	x <- scale(out$x, xc, xs)
	knots <- scale(out$knots, xc, xs)
	x0 <- scale(x0, xc, xs)
	if(!is.null(out$null.model)) {
		x.df <- as.data.frame(x)
		x.terms <- terms(out$null.model, data = x.df)
		tmat <- model.matrix(x.terms, data = x.df)
		X <- cbind(tmat, qr.yq2(out$matrices$qr.T, make.rb(x, knots, p
			 = out$power, with.constant = out$with.constant)))
	}
	else X <- cbind(make.tmatrix(x, out$m), qr.yq2(out$matrices$qr.T, 
			make.rb(x, knots, p = out$power, with.constant = out$
			with.constant)))
	temp <- (out$matrices$G) %*% diag(1/(1 + lambda * out$matrices$D))
	temp <- temp %*% t(out$matrices$G) %*% t(X)
	temp <- temp %*% diag(out$weights)	#
	n.terms <- length(out$d)
	M <- temp[1:n.terms,  ]
	t(M)	#	temp <- cbind(make.tmatrix(x0, out$m), qr.yq2(out$matrices$qr.T, 
#		make.rb(x0, knots, p = out$power, with.constant = out$
#		with.constant))) %*% temp	#
#
}
