"kernel.cov"<-
function(x1, x2, data, marginal = F, cor = F)
{
	if(missing(x2)) {
		symetric <- T
		x2 <- x1
	}
# if name of data set is given get it 
#
	if(is.character(data)) data <- get(data)	#
#
	M <- data$M
	rho <- data$rho
	PHI1 <- matrix(0, ncol = M, nrow(x1))	#
#
	if(marginal) {
		for(k in 1:M) {
			PHI1[, k] <- predict(data$fits[[k]], x1)
		}
		v1 <- data$cov.function(x, marginal = T)
		return(c(rho * v1 + PHI1^2 %*% data$delta[1:M]))
	}
#
#
#
	PHI2 <- matrix(0, ncol = M, nrow(x2))
	for(k in 1:M) {
		PHI1[, k] <- predict(data$fits[[k]], x1)
		PHI2[, k] <- predict(data$fits[[k]], x2)
	}
	temp1 <- rho * data$cov.function(x1, x2)
	temp2 <- (PHI1 %*% (data$delta[1:M] * t(PHI2)))	#
	temp1 + temp2
}
