"Smat.function2"<-
function(xmat, y = NULL, n.points = NULL, print.tc = F)
{
#browser()
	xmat <- as.matrix(xmat)
	xmat <- apply(xmat, 2, scale.01)
	if(is.null(n.points))
		n.points <- dim(xmat)[[2]] + 1
	n.obs <- dim(xmat)[[1]]
	Smat <- matrix(0, n.obs, n.obs)
	beta <- matrix(0, n.obs, n.points)
	c.nlen <- rep(0, n.obs)
	xmat
	distmat <- rdist(xmat, xmat)
	diag(distmat) <- 0	#plotd(xmat) ;text(xmat[,1]+.02,xmat[,2]+.02,1:75)
	for(i in 1:dim(distmat)[[1]]) {
		if(print.tc)
			print(i)
		c.n <- closest.n(distmat[i,  ], n = n.points)
		xmatsub <- as.matrix(xmat[c.n,  ])
		xtemp <- cbind(rep(1, dim(xmatsub)[[1]]), xmatsub)
		eig0 <- sum(svd(xtemp)$d < 0.001)
		temp.counter <- length(c.n)
		while(((sum(!dup.matrix(xmatsub)) < n.points) | (eig0 >= 1)) & 
			temp.counter < n.obs) {
			c.n <- closest.n(distmat[i,  ], n = temp.counter + 1)
			xmatsub <- as.matrix(xmat[c.n,  ])
			xtemp <- cbind(rep(1, dim(xmatsub)[[1]]), xmatsub)
			eig0 <- sum(svd(xtemp)$d < 0.001)
			temp.counter <- length(c.n)
			if(print.tc)
				print(paste("temp.counter incremented to:", 
				  temp.counter))
		}
#print(svd(xtemp)$d)
		xnew <- c(1, xmat[i,  ])
		c.nlen[i] <- length(c.n)
		xpxixp <- solve(t(xtemp) %*% xtemp) %*% t(xtemp)
		if(!is.null(y))
			beta[i,  ] <- xpxixp %*% y[c.n]
		Ppred <- t(as.matrix(xnew)) %*% xpxixp
		Smat[i, c.n] <- Ppred	#if(i==1) browser()
	}
	list(Smat = Smat, c.nlen = c.nlen, beta = beta)
}
