\name{sreg}
\alias{sreg}
\title{
Smoothing spline regression
}
\description{
Fits a cubic smoothing spline to univariate data. The amount of
smoothness can be specified or estimated from the data by GCV. The
assumed model is Y=f(x) +e where e should be approximately normal and
independent errors.
}
\usage{


sreg(x, y, lam=NA, offset=0, wt=rep(1, length(x)), cost=1, nstep.cv=50,
maxit.cv=10, deriv=0, find.trA=T, trmin=2.01, trmax=length(unique(x)) *
0.95, lammin=NA, lammax=NA) 


}
\arguments{
\item{x}{
Vector of x values
}
\item{y}{
Vector of y values
}
\item{lam}{
Smoothing parameter. If omitted this is estimated by GCV.
}
\item{offset}{
GCV is RSS/((1-(tr(A)-offset)*cost + offset)/n)^2, so that the degrees of
freedom can be adjusted with the offset.
}
\item{wt}{
A vector that is proportional to the standard deviation of the errors.
}
\item{cost}{
Cost value to be used in the GCV criterion.
}
\item{nstep.cv}{
Number of grid points for minimum GCV search
}
\item{maxit.cv}{
Maximum number of iterations for Golden Section search of optimum
}
\item{find.trA}{
Calculate the trace of A
}
\item{trmin}{
Control the range of smoothing parameters for the GCV grid search.
Trace of the A matrix is loosely speaking the number of parameters
associated with the spline smooth.
}
\item{lammin}{
Controls range of GCV grid search in smoothing parameter scale. 
}}
\value{
Returns a list of class sreg. This includes the predicted values and 
residuals. The lambda and the effective number of parameters for the fit
are
also returned. The results of the grid search to minimize GCV are returned
in cv.grid.
}
\details{
A smoothing spline is a locally weighted average of the data y's based
on the relative locations of the x values. Formally the estimate is
the curve that minimizes the criterion:
    (1/n) sum(k=1,n) ( Y_k - f( X_k))**2  + lambda* R(f)
where R(f) is the integral of the squared second derivative of f over
the range of the X values. The solution is a piecewise cubic
polynomial with the join points at the unique set of X values. The
polynomial segments are constructed so that the entire curve has
continuous first and second derivatives and the second and third
derivatives are zero at the boundaries.  The smoothing has the range
[0,infinity]. Lambda equal to  zero gives a cubic spline interpolation
of  the data. As lambda diverges to infinity ( e.g lambda =1e20) the 
estimate will converge to the straight line estimated by least squares.


 
    The values of the estimated
function at the data points can be expressed in the matrix form:


 
    predicted.values= A(lambda)Y
where A is an nXn symmetric matrix that does NOT depend on Y.
The diagonal elements are the leverage values for the estimate and the
sum of these  (trace(A(lambda)) can be interpreted as the effective
number of parameters that are used to define the spline function.
}
\references{
Additive Models by Hastie and Tibishirani
}
\seealso{
splint, tps
}
\examples{
sreg(rat.diet$t,rat.diet$con)-> fit # fit a GCV spline to 
# control group of rats. 
plot(fit)                       # diagonsotic plots of  fit
predict( fit) # predicted values at data points
xg<- seq(0,110,,50)
sm<- predict( fit, xg) # spline fit at 50 equally spaced points
der.sm<- predict( fit, xg, deriv=1) # derivative of spline fit
set.panel( 2,1)
plot( fit$x, fit$y) # the data
lines( xg, sm) # the spline
plot( xg,der.sm, type="l") # plot of estimated derivative


#
# the same fit using  the thin plate spline numerical algorithms
# (sreg is more efficient for 1-d problems)
#
tps( rat.diet$t,rat.diet$con)-> fit.tps




}
\keyword{smoothing}
% Converted by Sd2Rd version 0.3-2.


