\name{kernel.cov}
\alias{kernel.cov}
\title{
Nonstationary kernel covariance function
}
\description{
Represents a covariance function as the sum of a parametric component and 
an expansion using basis functions
}
\usage{
kernel.cov(x1, x2, obj, marginal=F, cor=F)
}
\arguments{
\item{x1}{
Locations to evaluate covariance. If x2 is missing x2 is replaced by x1. 
}
\item{obj}{
An object describing the parametric component and the basis functions.
This is usually created by as.general.cov.
}
\item{marginal}{
If true will just return the marginal variances at the x1 locations
}
\item{cor}{
If true will return correlations instead of covariances
}}
\value{
A covariance matrix where the number of rows is nrow( x1) and the number
of columns is nrow( x2)
}
\details{
For two locations x1 and x2, this covariance has the form:


rho*k(x1,x2)  + sum_\{j=1,M\}  phi_j(x1),phi_j(x2)


rho is parameter, k is a covariance function  and phi_j are M basis
functions.


  


      
}
\seealso{


as.kernel.cov


}
\examples{








}
% Converted by Sd2Rd version 0.3-2.
