"rhombic.design"<-
function(n.factors = 2, n.levels = c(4, 4), factor.names.arg = std.factor.names(
	n.factors), logx = F, digits = 4, plot.it = F)
{
## creates  rhombic lattice designs as described in
## David D. Doehlert (1970). "Uniform Shell Designs," Applied Statistics
##(JRSS, Series C) Vol 19, 231-239
	if(length(logx) == 1) logx <- rep(logx, n.factors)
	if(length(logx) != n.factors)
		stop(paste("Length of", substitute(logx), "can only be 1 or", 
			substitute(n.factors)))
	if(n.factors != 2)
		stop("n.factors=2 is the only choice right now :-(")
	if(any(n.levels < 3)) stop(
			"Error: must be at least 3 levels in each direction")	
	## make up the list of generates from p. 233/239 of the paper
##  gen.list <- list(d2=rbind(c(0,0),c(1,0),c(.5,.86602)))
##  gen.list$d3 <- rbind(cbind(gen.list[[1]],rep(0,3)), 
##		       c(.5,.28868,.81650))
##  gen.list$d4 <- rbind(cbind(gen.list[[2]],rep(0,4)), 
##		       c(.5,.28868,.20413,.79057))
	gen.list <- vector("list", length = 10)
	names(gen.list) <- paste("d", 2:11, sep = "")
	gen.list[[1]] <- rbind(c(0, 0), c(1, 0), c(1/2, sqrt(3/4)))
	for(j in 2:10) {
## j = d-1
		gen.mat <- gen.list[[j - 1]]
		gen.mat <- cbind(gen.mat, rep(0, j + 1))
		new.pt <- gen.mat[j + 1, 1:(j - 1)]
		new.pt <- c(new.pt, 1/sqrt(2 * (j + 1) * j), sqrt((j + 2)/(2 * (
			j + 1))))
		gen.mat <- rbind(gen.mat, new.pt)
		gen.list[[j]] <- gen.mat
	}
	max.factors <- length(gen.list) + 1
	if(n.factors > max.factors)
		stop(paste("\nError: Program will handle only up to", 
			max.factors, "factors right now.\n"))
	gen.mat <- gen.list[[n.factors - 1]]	
	## if there are d factors, there are d+1 rows in the generating
## matrix. The variable n.levels specifies the number of points
## to the "right" and "left" of the origin in each dimension
## You get each successive generation by adding and subtracting
## the designated number of times. The total number of points
## should be prod(n.levels)+1. 
	d <- n.factors
	if(length(n.levels) == 1)
		n.levels <- rep(n.levels, d)
	n.gen <- d + 1
	n <- prod(2 * n.levels + 1)	## make the generator matrix symmetric
	for(i in 1:d) {
		if(i == 1)
			diag.mat <- diag(c(-1, rep(1, d - 1)))
		if(i > 1 & i < d)
			diag.mat <- diag(c(rep(1, i - 1), -1, rep(1, d - i)))
		if(i == d)
			diag.mat <- diag(c(rep(1, d - 1), -1))
		gen.mat <- rbind(gen.mat, gen.mat %*% diag.mat)
		gen.mat <- gen.mat[!dup.matrix(gen.mat),  ]
	}
	gen.mat <- gen.mat[!dup.matrix(gen.mat),  ]
	des.mat <- gen.mat
	if(plot.it) {
		plot(des.mat)
		locator(1)
	}
	for(j in 2:n.gen) {
		k <- n.levels[j - 1] - 3
		if(k > 0) {
			for(m in 1:k) {
				diff.mat <- matrix(gen.mat[j,  ], nrow = nrow(
				  des.mat), ncol = d, byrow = T)
				add.mat <- des.mat + diff.mat
				sub.mat <- des.mat - diff.mat
				new.des.mat <- rbind(des.mat, add.mat, sub.mat)
				if(plot.it) {
				  plot(new.des.mat, type = "n")
				  points(des.mat, mark = 4, col = 1)
				  points(add.mat, mark = 1, col = 2)
				  points(sub.mat, mark = 2, col = 3)
				  locator(1)
				}
				des.mat <- new.des.mat
			}
		}
	}
	if(plot.it) {
		plot(des.mat)
		locator(1)
	}
## now make the design matrix symmetric
	for(i in 1:d) {
		if(i == 1)
			diag.mat <- diag(c(-1, rep(1, d - 1)))
		if(i > 1 & i < d)
			diag.mat <- diag(c(rep(1, i - 1), -1, rep(1, d - i)))
		if(i == d)
			diag.mat <- diag(c(rep(1, d - 1), -1))
		des.mat <- rbind(des.mat, des.mat %*% diag.mat)
		des.mat <- des.mat[!dup.matrix(des.mat),  ]
	}
	if(plot.it) plot(des.mat, col = 2)	
	## now assign the factor names and levels
	if(!is.list(factor.names.arg)) {
		fnames <- as.list(rep(0, n.factors))
		names(fnames) <- factor.names.arg
		for(i in 1:n.factors)
			if(logx[i]) fnames[[i]] <- log(c(0.10000000000000001, 
				  10)) else fnames[[i]] <- c(-1, 1)
	}
	else {
		if(length(factor.names.arg) != n.factors)
			stop(paste(
				"Number of elements in factor.names.arg must equal",
				n.factors))
		if(!all(sapply(factor.names.arg, function(x)
		length(x) == 2)))
			stop(paste("If a list, each component of", 
				"factor.names.arg must have length 2"))
		fnames <- factor.names.arg
		for(i in 1:n.factors)
			if(logx[i]) fnames[[i]] <- log(fnames[[i]])
	}
	des.mat <- des.mat/max(abs(des.mat))
	des <- data.frame(des.mat)
	des <- eval(parse(text = paste("des[order(", paste("des[,", 1:n.factors,
		"]", sep = "", collapse = ","), "),]", sep = "")))
	for(i in 1:n.factors) {
		x <- fnames[[i]]
		y <- des[, i]
		a <- x[1]
		b <- x[2]
		center.x <- 0.5 * (a + b)
		scale.x <- (b - a)/2
		y <- y * scale.x + center.x
		attributes(y) <- list(log = logx[i], scale = scale.x, center = 
			center.x, class = "rsm.factor")
		des[, i] <- y
	}
	dimnames(des) <- list(1:nrow(des), names(fnames))
	class(des) <- c("rsm.design", "design", "data.frame")
	des
}
