"make.tmatrix.S"<-
function(x, m = 2)
{
	if(!is.matrix(x))
		x <- as.matrix(x)
	p <- m - 1
	d <- ncol(x)	#
	n <- nrow(x)	#cat(d, n, fill = T)	
	ptab <- NA
	ind <- (1:d) + 1
	end <- ind[d]	#
#  find  (d+P) choose d
# the number of polynomial terms
#
	N <- as.integer(prod(((p + 1):(p + d))/(1:d)))	
	# set final size of matrix
# 
	A <- matrix(NA, ncol = N, nrow = n)	
	# power table starts with linear terms 
	ptab <- matrix(0, ncol = N, nrow = d)
	unit <- diag(rep(1, d))	# first column are the constants
	A[, 1] <- rep(1, n)	#
#
# special case when m=1 just a constant term 
	if(p == 0) {
		attribute(A, "ptab") <- t(ptab)
		return(A)
	}
#
# OK now do the nontrivial cases 
#  next d columns are the linear terms
#
	A[, ind] <- x	#
	ptab[, ind] <- unit	#
# if degree is higher than linear then add int eh other columns to A.
# Each higher degree column is found by multiplying preivous columns
# by one of the variables. 
	if(p > 1) {
		for(j in 2:p) {
			k1 <- end + 1
			for(i in 1:d) {
				k2 <- end - ind[i] + k1	###
				A[, k1:k2] <- x[, i] * A[, ind[i]:end]	#
# now update power table
#
				ptab[, k1:k2] <- ptab[, ind[i]:end] + unit[, i]
		###	
				ind[i] <- k1
				k1 <- k2 + 1
			}
			end <- k2
		}
	}
	attribute(A, "ptab") <- t(ptab)
	A
}
