"make.DTd"<-
function(x1, dcoef, m = 2)
{
	x1 <- as.matrix(x1)
	hold <- make.tmatrix(matrix(x1[1,  ], ncol = ncol(x1)), m)
	ptab <- attributes(hold)$ptab	#	print(ptab)
	nd <- ncol(x1)
	n1 <- nrow(x1)
	np <- nrow(ptab)
	if(length(dcoef) != np)
		stop("mismatch between number of\npolynomials and the length of the d vector"
			)
	matrix(.Fortran("mltdtd",
		nd = as.integer(nd),
		x1 = as.double(x1),
		n1 = as.integer(n1),
		np = as.integer(np),
		ptab = as.integer(ptab),
		d = as.double(dcoef),
		h = as.double(rep(0, nd * n1)))$h, ncol = nd)
}
