"leaps.design"<-
function(loc, cov.function, y = rep(1/ncol(x), ncol(x)), nbest = 1, names.arg
	 = format(1:ncol(x)), method = 1, df = c(ncol(x) + 1), tol = 0.0001, 
	...)
{
#   x -- covariance matrix on design points
#   coefficient of linear form/functional to be estimated by default, 
#       arithimetical mean is computed
#   method = 1, using R2 criterion
#   method = 2; using adjusted R2 criterion
#   method = 3, using Cp statistic
	x <- cov.function(loc, loc, ...)
	kx <- ncol(x)
	dropint <- T	#       rr <- crossprod(cbind(x, y))    
	rr <- cbind(x, x %*% y)
	rr <- rbind(rr, c(t(y) %*% x, t(y) %*% x %*% y))
	maxreg <- kx * nbest
	ans <- .Fortran("leaps",
		as.single(rr),
		as.integer(kx),
		as.integer(kx + 1),
		as.integer(df),
		as.integer(method),
		as.integer(nbest),
		as.single(tol),
		regid = integer(maxreg),
		Cp = single(maxreg),
		size = integer(maxreg),
		nreg = integer(1),
		single((nbest + 4) * (kx + 1) + (((kx + 1) * (kx + 2))/2) * ((2 *
			(kx + 3))/3 + 1)),
		integer(4 * (kx + 1)^2 + 8 * (kx + 1) + (nbest + 1) * (kx + 1))
			)
	ans <- ans[c("Cp", "size", "nreg", "regid")]	
	#  cleanup Fortran output; fix Cp, r2 and adjr2.
	nreg <- ans$nreg
	Cp <- ans$Cp
	length(Cp) <- nreg
	size <- ans$size
	length(size) <- nreg
	size <- size
	z <- ans$regid
	length(z) <- nreg	
	#  Rick Becker's mask function to create which and then labels
	which <- matrix(as.logical((rep.int(z, kx) %/% rep.int(2^((kx - 1):0), 
		rep.int(length(z), kx))) %% 2), byrow = F, ncol = kx)
	ans <- list(r2 = Cp, size = size, which = which)
	ans$call <- match.call()
	ans$loc <- loc
	class(ans) <- "sdesign"
	ans$weights <- y
	ans$subset <- which
	ans
}
