"cgram"<-
function(loc, cormat, lon.lat = F)
{
	loc <- as.matrix(loc)
	n <- nrow(loc)
	ind <- rep(1:n, n) > rep(1:n, rep(n, n))
	id <- cbind(rep(1:n, n), rep(1:n, rep(n, n)))[ind,  ]
	if(lon.lat) {
		d <- c(rdist.earth(loc))[ind]
	}
	else {
		d <- dist(loc)
	}
	temp <- c(cormat[id])
	call <- match.call()
	out <- list(d = d, cgram = temp, id = id, loc = loc, call = call)
	class(out) <- c("cgram", "vgram")
	out
}
