"arrow.plot"<-
function(a1, a2, u = NA, v = NA, arrow.ex = 0.050000000000000003, add = F, size
	 = 0.20000000000000001, open = T, rel = T, xpd = T, true.angle = F, col
	 = 1, ...)
{
#
#rearrange arguments  if things are passed as matrices
#
	if(is.matrix(a1)) {
		x <- a1[, 1]
		y <- a1[, 2]
	}
	else {
		x <- a1
		y <- a2
	}
	if(is.matrix(a2)) {
		u <- a2[, 1]
		v <- a2[, 2]
	}
#
# set up the plot if not an add on
#
	if(!add) {
		plot(x, y, type = "n", ...)
	}
	ucord <- par()$usr
	arrow.ex <- arrow.ex * min(ucord[2] - ucord[1], ucord[4] - ucord[3])
	if(true.angle) {
# to preserve the true angle think of u and v being given in inches on the
# plot
# need to figure out how to scale to be in x and y untis. 
		pin <- par()$pin	# scale factors:
		r1 <- (ucord[2] - ucord[1])/(pin[1])
		r2 <- (ucord[4] - ucord[3])/(pin[2])
	}
	else {
		r1 <- r2 <- 1
	}
	u <- u * r1
	v <- v * r2
	maxr <- max(sqrt(u^2 + v^2))	#
#
# rescale u and v so that lengths fit on plot
#
	u <- (arrow.ex * u)/maxr
	v <- (arrow.ex * v)/maxr
	invisible()
	old.xpd <- par()$xpd
	par(xpd = xpd)
	arrows(x, y, x + u, y + v, size = size, open = open, rel = rel, col = 
		col)
	par(xpd = old.xpd)
}
