      SUBROUTINE LSFIT(FMAT,FWORK,N,NTREND,LDF,YVEC,BETA,ERRBTA,
     .                  DEV,ERRDEV,
     .                  COVBTA,LDCVBT,SGSQR,CMINV,LDCINV,
     .                  CWORK,LDCWRK,CWRK2,LDCWK2,
     .                  FERR,BERR,WORK,LWORK,
     .                  IPVT,IPIV,IWORK,IERR)

      IMPLICIT NONE
      INTEGER N,NTREND,LWORK,IERR,LDF,IPVT(*),IWORK(*),METHOD,
     .        IPIV(*),LDCVBT,LDCINV,LDCWRK,LDCWK2,
     .        LDFERR,LDBERR
      DOUBLE PRECISION FMAT(LDF,*),FWORK(LDF,*),YVEC(*),BETA(*),DEV(*),
     .                 WORK(*),COVBTA(LDCVBT,*),
     .                 CMINV(LDCINV,*),CWORK(LDCWRK,*),CWRK2(LDCWK2,*),
     .                 SGSQR,ERRDEV,ERRBTA,FERR(*),BERR(*)
c
c     perform a ordinary least squares fit
c
c     YVEC = FMAT * BETA + DEV
c     E(DEV)   = 0
c     COV(DEV) = SQSQR * I
c
c     solved by LAPACK routine DGELS
c
c     
c     SQSRQ = DEV**T * DEV / (N-NTREND)
c     COVBTA = SGSQR * (FMAT**T * FMAT)**-1

c     external subroutines
      EXTERNAL MATPR, DPOTRF, DPOTRI, DGEMM, DGGGLE, DGEFA, DGEDI

c     local variables
      INTEGER I, J
      DOUBLE PRECISION DEVSUM, RCOND 

      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D0, ZERO = 0.0D0 )

c     debug options
      CHARACTER*16 NAME
      INTEGER DBGLVL
      COMMON /DEBUG/ DBGLVL

c     check for existence of solution:
      IF (N.LE.NTREND) THEN
         IERR=1
         RETURN
      END IF

c      name='cmat\0'
c      call matpr(name,cmat,n,n,ldc,dbglvl)
c      name='fmat\0'
c      call matpr(name,fmat,n,ntrend,ldf,dbglvl)
c      name='yvec\0'
c      call matpr(name,yvec,n,1,n,dbglvl)


c     now solve the ols problem, destroys YVEC!
c     save YVEC in DEV
      DO 211 I=1,N
         DEV(I)=YVEC(I)
 211  CONTINUE         
      CALL DGELSE('N',N,NTREND,1,FWORK,LDF,YVEC,N,WORK, LWORK,
     $            IWORK, ERRBTA, IERR)
      IF ( IERR .NE. 0 ) THEN 
         CALL ERRMSG('GLSFIT DGELSE: error',16,IERR)
         RETURN
      ELSE
         DO 213 I=1,NTREND
            BETA(I)=YVEC(I)
 213     CONTINUE         

      END IF

c     calculate residuals: dev = Y - F * BETA
c     DEV already contains YVEC!
      CALL DGEMV('N',N,NTREND,-ONE,FMAT,LDF,BETA,1,ONE,DEV,1)
      
c     intermediate state: CMINV = FMAT^T  * FMAT
      CALL DGEMM('T','N',NTREND,NTREND,NTREND,ONE,
     .            FMAT,LDF,FMAT,LDF,ZERO,CMINV,LDCINV)
c     ... ^ -1
c     rhs (=I)
      DO 333 I=1,NTREND
         DO 334 J=1,NTREND
            IF( I.EQ.J) THEN
               CWORK(I,J)=ONE
            ELSE
               CWORK(I,J)=ZERO
            END IF
 334     CONTINUE
 333  CONTINUE

c     inverse of F'*F:
      CALL DSYSVX( 'N', 'U', NTREND, NTREND, CMINV, LDCINV, CWORK, 
     $             LDCWRK, IPIV, CWORK, LDCWRK, COVBTA, LDCVBT,
     $             RCOND, FERR, BERR, WORK, LWORK, IWORK, IERR )
      IF ( IERR .NE. 0) THEN         
         IF ( IERR .LT. 0 ) THEN 
            CALL ERRMSG('GLSFIT DSYSVX: argument no IERR wrong',38, 
     $                  -IERR)
         ELSE
            IF ( IERR .EQ. NTREND+1 ) THEN
               CALL ERRMSG('GLSFIT DSYSVX: matrix singular to working pr
     $ecision',52,0)
            ELSE
               CALL ERRMSG('GLSFIT DSYSVX: D(IERR,IERR)=0 !',32,IERR)
            END IF
         END IF
         RETURN
      END IF


c     no error bounds for dev:
      ERRDEV=-1

c     estimate variance SGSQR
      IF (N.GT.NTREND) THEN
         DEVSUM=ZERO
         DO 30 I=1,N
            DEVSUM=DEVSUM+DEV(I)*DEV(I)
 30      CONTINUE
         SGSQR=ONE/(N-NTREND)*DEVSUM
      ELSE
         SGSQR=ZERO
      END IF

c     final step
      DO 40 I=1,NTREND
         DO 41 J=1,NTREND
            COVBTA(I,J)=COVBTA(I,J)*SGSQR
 41      CONTINUE
 40   CONTINUE

      RETURN
      END
