      SUBROUTINE DGELSE( TRANS, M, N, NRHS, A, LDA, B, LDB, WORK, LWORK,
     $                   IWORK, ERRBD, INFO )

      IMPLICIT NONE
      CHARACTER          TRANS
      INTEGER            INFO, LDA, LDB, LWORK, M, N, NRHS, IWORK(*)
      DOUBLE PRECISION   A( LDA, * ), B( LDB, * ), WORK( * ), ERRBD(*)

c
c     LSE with error bound according to code snippet in
c     LAPACK Users Guide, ver 3, transformed from REAL to DOUBLE
c
c     parameters: 
c       see DGELS
c       +
c       ERRBD  (out) DOUBLEPRECISION:    relative error bound
c       IWORK for DTRCON

c     external functions
      DOUBLE PRECISION DLAMCH, DNRM2
      EXTERNAL DLAMCH, DNRM2

c     external subroutines
      EXTERNAL DGELS, DTRCON

c     constants
      DOUBLE PRECISION ONE, ZERO
      PARAMETER          ( ONE = 1.0D0, ZERO = 0.0D0 )

c     local variables
      INTEGER I
      DOUBLE PRECISION EPSMCH, BNORM, RNORM, RCOND, SINT, COST, TANT

      
      EPSMCH = DLAMCH( 'E' )
*     Get the 2-norm of the right hand side B
      BNORM = DNRM2( M, B, 1 )
*     Solve the least squares problem; the solution X overwrites B
*     ( TRANS = 'N' )
      CALL DGELS( TRANS, M, N, NRHS, A, LDA, B, LDB, WORK, LWORK, INFO )
      IF ( MIN(M,N) .GT. 0 ) THEN
         DO 10 I=1,NRHS
*     Get the 2-norm of the residual A*X-B
            RNORM = DNRM2( M-N, B( N+1, I ), 1 )
*     Get the reciprocal condition number RCOND of A
            CALL DTRCON('I', 'U', 'N', N, A, LDA, RCOND, WORK, IWORK,
     $                  INFO)
            RCOND = MAX( RCOND, EPSMCH )
            IF ( BNORM .GT. ZERO ) THEN
               SINT = RNORM / BNORM
            ELSE
               SINT = ZERO
            ENDIF
            COST = MAX( SQRT( (ONE - SINT)*(ONE + SINT) ), EPSMCH )
            TANT = SINT / COST
            ERRBD(I) = EPSMCH*( 2*ONE/(RCOND*COST) + TANT / RCOND**2 )
 10      CONTINUE
      ENDIF
      RETURN
      END
