      SUBROUTINE BKTLWR(DATVEC,
     .                  DBLVEC,
     .                  INTVEC,
     .                  ZG,
     .                  LDZG,
     .                  VARG,
     .                  LDVARG,
     .                  DOG,
     .                  LDDOG,
     .                  COVPAR,
     .                  COVMAT,
     .                  LDCOV,
     .                  C0VEC,
     .                  COV0,
     .                  MUPR,
     .                  LDMPR,
     .                  PHIPR,
     .                  LDPHPR,
c     .                  PRINV,
c     .                  LDPRIV,
     .                  PHIWRK,
     .                  LDPHWK,
     .                  LONPR,
     .                  LATPR,
     .                  COVBTA,
     .                  LDCVBT,
     .                  CVSRNB,
     .                  RSEARCH,
     .                  FWORK,
     .                  FWRK2,
     .                  LDFWRK,
     .                  F0WORK,
     .                  KWORK,
     .                  LDKWRK,
     .                  RHSWORK,
     .                  FPWORK,
     .                  FPFWORK,
     .                  FPF0WRK,
     .                  CHLUP,
     .                  LDCLUP,
     .                  CMINV,
     .                  LDCINV, 
     .                  MU,
     .                  LAMBDA,
     .                  LAMBD0,
     .                  IERR)

      IMPLICIT NONE
      INTEGER LDCOV,LDFWRK,LDMPR,LDPHPR,LDPHWK,LDPRIV,LDCVBT,LDCLUP,
     .        LDCINV,LDKWRK,LDZG,LDVARG,LDDOG,
     .        INTVEC(*),IERR,DOG(LDDOG,*)                                LDPRIV
      DOUBLE PRECISION DATVEC(*),DBLVEC(*),
     .                 ZG(LDZG,*),VARG(LDVARG,*),
     .                 COVMAT(LDCOV,*),C0VEC(*),COV0,
     .                 RSEARCH,FWORK(LDFWRK,*),F0WORK(*),
     .                 KWORK(LDKWRK,*),RHSWORK(*),MU(*),
     .                 LAMBDA(*),FWRK2(LDFWRK,*),
     .                 COVPAR(*),
     .                 FPWORK(LDFWRK,*),FPFWORK(LDFWRK,*),
     .                 FPF0WRK(LDFWRK,*),MUPR(LDMPR,*),
     .                 PHIPR(LDPHPR,*),PHIWRK(LDPHWK,*),LAMBD0,
     .                 LONPR(*),LATPR(*),                                PRINV(LDPRIV,*),
     .                 COVBTA(LDCVBT,*),
     .                 CHLUP(LDCLUP,*),CMINV(LDCINV,*),
     .                 CVSRNB(LDCOV,*)

c     call wrapper for BKGRID to reduce no of parameters to be passed 
c     from R:
c
c     all double data goes to DATVEC, remaining things to DBLVEC (double)
c     and INTVEC (integer)
c
c     DATVEC=XSW+YSW+XNE+YNE+ANGLE+DX+DY+LON+LAT+Z
c     length= 1   1   1   1   1     1  1  N   N  N
c
c     DBLVEC=XG+YG+ muwrk beta errbeta dev errdev zsrnb dist work ferr berr
c     length=NX+NY+ ntrend+ntrend  +1  +n     +1   +n    +n +lwork +n   +n
c
c     INTVEC=NX NY NZ EXTRAP N COVTYPE TREND NTREND NPR TYPPR NSEARCH NSMIN 
c     length= 1  1  1    1   1    1      1      1    1   npr     1     1 
c            NSMAX INDSNB INDSNW INDSRT LWORK IPVT    IPIV   IWORK MODE GLSMTH
c       ...   1      n       n      n     1  ntrend n+ntrend  3*n   1     1
c       ...  BITS
c       ...  nz+nz*n+1 (pos nz+1=usesnbbit)
c     total: 15 + npr + 7*n + 2*ntrend + nz+nz*n+1 

c     debug options
      CHARACTER*16 NAME
      INTEGER DBGLVL
      COMMON /DEBUG/ DBGLVL

      DBGLVL=0

c             wrapped parameters                                  orig. params(..orig ints)
      CALL BKTILE(DATVEC(1),                                            XSW
     .            DATVEC(2),                                            YSW
     .            DATVEC(3),                                            XNE
     .            DATVEC(4),                                            YNE
     .            DATVEC(5),                                            ANGLE
     .            INTVEC(1),                                            NX
     .            INTVEC(2),                                            NY
     .            INTVEC(3),                                            NZ
     .            DATVEC(6),                                            DX
     .            DATVEC(7),                                            DY
     .            DBLVEC(1),                                            XG
     .            DBLVEC(INTVEC(1)+1),                                  YG(NX)
     .            ZG,
     .            VARG,
     .            DOG,
     .            DATVEC(8),                                            LON
     .            DATVEC(8+INTVEC(5)),                                  LAT(N)
     .            DATVEC(8+2*INTVEC(5)),                                Z(..)
     .            INTVEC(4),                                            EXTRAP
     .            INTVEC(5),                                            N
     .            INTVEC(6),                                            COVTYPE
     .            COVPAR,
     .            COVMAT,
     .            LDCOV,
     .            C0VEC,
     .            COV0,
     .            INTVEC(7),                                            TREND
     .            INTVEC(8),                                            NTREND
     .            MUPR,
     .            LDMPR,
     .            PHIPR,
     .            LDPHPR,
c     .            PRINV,
c     .            LDPRIV,
     .            DBLVEC(INTVEC(1)+INTVEC(2)+1),                        MUWRK(..NY)
     .            PHIWRK,
     .            LDPHWK,
     .            LONPR,
     .            LATPR,
     .            DBLVEC(INTVEC(1)+INTVEC(2)+INTVEC(8)+1),              BETA(..NTREND)
     .            DBLVEC(INTVEC(1)+INTVEC(2)+2*INTVEC(8)+1),            ERRBTA
     .            COVBTA,
     .            LDCVBT,
     .            DBLVEC(INTVEC(1)+INTVEC(2)+2*INTVEC(8)+2),            DEV
     .            DBLVEC(INTVEC(1)+INTVEC(2)+2*INTVEC(8)+INTVEC(5)+2),  ERRDEV(..N)
     .            CVSRNB, 
     .            DBLVEC(INTVEC(1)+INTVEC(2)+2*INTVEC(8)+INTVEC(5)+3),  ZSRNB
     .            INTVEC(9),                                            NPR
     .            INTVEC(10),                                           TYPPR
     .            RSEARCH,
     .            INTVEC(10+INTVEC(9)),                                 NSEARCH(NPR)
     .            INTVEC(11+INTVEC(9)),                                 NSMIN
     .            INTVEC(12+INTVEC(9)),                                 NSMAX
     .            FWORK,
     .            FWRK2,
     .            LDFWRK,
     .            F0WORK,
     .            DBLVEC(INTVEC(1)+INTVEC(2)+2*INTVEC(8)+2*INTVEC(5)+3),DIST
     .            INTVEC(13+INTVEC(9)),                                 INDSNB
     .            INTVEC(13+INTVEC(9)+INTVEC(5)),                       INDSNW(..N)
     .            INTVEC(13+INTVEC(9)+2*INTVEC(5)),                     INDSRT
     .            KWORK,
     .            LDKWRK,
     .            RHSWORK,
     .            FPWORK,
     .            FPFWORK,
     .            FPF0WRK,
     .            CHLUP,
     .            LDCLUP,
     .            CMINV,
     .            LDCINV,
     .            DBLVEC(INTVEC(1)+INTVEC(2)+2*INTVEC(8)+3*INTVEC(5)+3),WORK
     .            INTVEC(13+INTVEC(9)+3*INTVEC(5)),                     LWORK
     .            INTVEC(14+INTVEC(9)+3*INTVEC(5)),                     IPVT
     .            DBLVEC(INTVEC(1)+INTVEC(2)+2*INTVEC(8)+3*INTVEC(5)+
     .                            INTVEC(13+INTVEC(9)+3*INTVEC(5))+3),  FERR(..LWORK)
     .            DBLVEC(INTVEC(1)+INTVEC(2)+2*INTVEC(8)+4*INTVEC(5)+
     .                            INTVEC(13+INTVEC(9)+3*INTVEC(5))+3),  BERR
     .            INTVEC(14+INTVEC(9)+3*INTVEC(5)+INTVEC(8)),           IPIV(..NTREND)
     .            INTVEC(14+INTVEC(9)+4*INTVEC(5)+2*INTVEC(8)),         IWORK(..N+NTREND
     .            INTVEC(14+INTVEC(9)+7*INTVEC(5)+2*INTVEC(8)),         MODE(..3*N)
     .            MU,
     .            LAMBDA,
     .            LAMBD0,
     .            INTVEC(16+INTVEC(9)+7*INTVEC(5)+2*INTVEC(8)),         BITS(..NZ+N*NZ+1)
     .            IERR,
     .            INTVEC(15+INTVEC(9)+7*INTVEC(5)+2*INTVEC(8)))         GLSMTH

      RETURN
      END

      SUBROUTINE BKTILE(XSW,
     .                  YSW,
     .                  XNE,
     .                  YNE,
     .                  ANGLE,
     .                  NX,
     .                  NY,
     .                  NZ,
     .                  NTX,
     .                  NTY,
     .                  NT,
     .                  DX,
     .                  DY,
     .                  ITX,
     .                  ITY,
     .                  IPT,
     .                  XG,
     .                  YG,
     .                  ZG,
     .                  VARG,
     .                  DOG,
     .                  XGWORK,
     .                  YGWORK,
     .                  LON,
     .                  LAT,
     .                  Z,
     .                  EXTRAP,
     .                  N,
     .                  COVTYPE,
     .                  COVPAR,
     .                  COVMAT,
     .                  C0,
     .                  COV0,
     .                  TREND,
     .                  NTREND,
     .                  RSEARCH,
     .                  NSEARCH,
     .                  NSMIN,
     .                  NSMAX,
     .                  FWORK,
     .                  FWRK2,
     .                  F0WORK,
     .                  DIST,
     .                  INDSNB,
     .                  INDSNA,
     .                  INDSRT,
     .                  KWORK,
     .                  NKWORK,
     .                  RHSWORK,
     .                  IPIV,
     .                  MODE,
     .                  MU,
     .                  LAMBDA,
     .                  X0,
     .                  Y0,
     .                  Z0,
     .                  DO0,
     .                  INDDO,
     .                  VAR0,
     .                  BITS,
     .                  IERR,
     .                  GLSMTH)

      INTEGER NX,NY,NZ,NTX,NTY,NT,ITX,ITY,N,COVTYPE,TREND,NTREND,
     .        NSEARCH,NSMIN,NSMAX,MODE,IERR,INDSNB(*),INDSNA(*),
     .        INDSRT(*),IPIV(*),IPT,EXTRAP,DOG(NX,*),DO0(*),inddo(*)
      DOUBLE PRECISION XSW,YSW,XNE,YNE,ANGLE,DX,DY,
     .                 XG(*),YG(*),ZG(NX,*),VARG(NX,*),
     .                 LON(*),LAT(*),Z(*),COVMAT(N,*),C0(*),COV0(N,*),
     .                 RSEARCH,FWORK(N,*),F0WORK(NTREND,*),DIST(*),
     .                 KWORK(NKWORK,*),RHSWORK(NKWORK,*),MU(NTREND,*),
     .                 LAMBDA(N,*),X0(*),Y0(*),Z0(*),VAR0(*),
     .                 XGWORK(NX,*),YGWORK(NX,*),COVPAR(*),
     .                 FWRK2(N,*)

c     subroutine for kriging prediction on tiles of a grid
c     
c     This subroutine takes the grid specification, forms tiles
c     (i.e. rectangular subregions of the grid) and calls KRIGE
c     (see below) on these tiles. The idea is to reduce computational
c     burden by collecting some neigbouring "krige"-systems and 
c     forming a combined krige system with multiple right hand sides
c     to be solved by DGESV simultaneously.
c
c
c     
c            [1,1]                              ne       
c              +-----------+----------+--------+    
c              | o   o   o | o   o   o|  o   o |      o    -- grid points (i,j)
c              |(1,1)      |          |     x  |    
c              | o   o   o | o   o   o|  o   o |    +---+
c              |           |          |        |    | o |  -- grid tiles  [i,j]
c              | o   o   o | o   o   o|  o   o |    +---+
c              +-----------+----------+--------+
c            1 | o   o   o | o   o   o|  o   o |      x    -- user specified
c              |           |          |        |_             sw/ne corners
c       N   ...| o   o   o | o   o   o|  o   o | \ 
c        +     |           |          |        |  > dy
c         \ ity| o   o   o | o   o   o|  o   o |_/
c          \   +-----------+----------+--------+
c           \  | o   o   o | o   o   o|  o   o |     
c            \ |  x        |          | (ny,nx)|         
c             \| o   o   o | o   o   o|  o   o |    
c              +-----------+----------+--------+
c            sw  1  ... itx      \_ _/     [nty,ntx]
c                                  v
c                                   dx
c     parameters
c     XSW,YSW          lon/lat of sw-corner
c     XNE,YNE          lon/lat of ne-corner
c     ANGLE            angle to add to N-S 
c     NX,NY            no. of grid points in x / y direction (at least 2)
c     NZ               overall no of grid points (=NX*NY)
c     NTX,NTY          no. of tiles in x / y direction (at least 1)
c     NT               overall no of grid tiles (=NTX*NTY)
c     DX,DY            grid cell size
c     ITX,ITY          grid tile size (in no. of grid points per tile)
c     XG,YG,ZG,VARG    arrays to hold the output (grid coords. and 
c                      prediction)
c     LON,LAT,Z,N      data set
c     X0,Y0,Z0,VAR0    arrays to hold the input/output (grid coords. and 
c                      prediction) for one tile.
c     ...              ... other work arrays to pass through to KRIGE

c     local variables
      INTEGER I,J,K,L,LIPT
      DOUBLE PRECISION DELTA
      CHARACTER*16 NAME

c     constants
      integer dbglvl
      dbglvl=0

c     build/check grid and tile parameters:
      IF (NX*NY.NE.NZ) THEN
          write(*,*) "wrong value of nz (should be nx*ny)"
         IERR=1
         RETURN
         END IF
      IF (NTX*NTY.NE.NT) THEN
          write(*,*) "wrong value of nt (should be ntx*nty)"
         IERR=1
         RETURN
      END IF

c      IF (NX.GE.2 .AND. DX.EQ.0) THEN 
c         DX=(XNE-XSW)/(NX-1)
c         write (*,*)dy
c      ELSE IF (DX.GE.0) THEN
c         NX=AINT((XNE-XSW)/DX)+1
c         DELTA=XSW+NX*DX-XNE
c         XSW=XSW-DELTA/2
c         XNE=XNE+DELTA/2
c      ELSE
c         write(*,*) "wrong x dimension of grid"
c         IERR=1
c         RETURN
c      END IF
c
c      IF (NY.GE.2 .AND. DY.EQ.0) THEN 
c         DY=(YNE-YSW)/(NY-1)
c         WRITE (*,*)DY
c      ELSE IF (DY.GE.0) THEN
c         NY=AINT((YNE-YSW)/DY)+1
c         DELTA=YSW+NY*DY-YNE
c         YSW=YSW-DELTA/2
c         YNE=YNE+DELTA/2
c      ELSE
c         write(*,*) "wrong y dimension of grid"
c         IERR=1
c         RETURN
c      END IF

c      IF (NTX.GE.1) THEN 
c         ITX=INT(NX/NTX)+1
c      ELSE IF (ITX.GE.0) THEN
c         NTX=INT(NX/ITX)+1
c      ELSE
c         write(*,*) "wrong x dimension of tiles"
c         IERR=1
c         RETURN
c      END IF

c      IF (NTY.GE.1) THEN 
c         ITY=INT(NY/NTY)+1
c      ELSE IF (ITY.GE.0) THEN
c         NTY=INT(NY/ITY)+1
c      ELSE
c         write(*,*) "wrong y dimension of tiles"
c         IERR=1
c         RETURN
c      END IF

      DO 1 I=1,NY
         YG(I)=YSW+DY*(I-1)
 1    CONTINUE
      DO 2 J=1,NX
         XG(J)=XSW+DX*(J-1)
 2    CONTINUE
      name="xg"
      call matpr(xg,nx,1,nx,name,dbglvl)
      name="yg"
      call matpr(yg,ny,1,ny,name,dbglvl)

      DO 4 I=1,NX
         DO 3 J=1,NY
            YGWORK(I,J)=YG(J)
            XGWORK(I,J)=XG(I)
 3       CONTINUE
 4    CONTINUE
      name="xgwork"
      call matpr(xgwork,nx,ny,nx,name,dbglvl)
      name="ygwork"
      call matpr(ygwork,nx,ny,nx,name,dbglvl)

c     prepare the covariance matrix
      IF (COVTYPE.NE.0) THEN
         DO 1000 I=1,N
            DO 1001 J=I,N
               COVMAT(I,J)=COVFN(COVTYPE,COVPAR,
     .                        SQRT((LON(I)-LON(J))*(LON(I)-LON(J))+
     .                             (LAT(I)-LAT(J))*(LAT(I)-LAT(J))))
               COVMAT(J,I)=COVMAT(I,J)
 1001       CONTINUE
 1000    CONTINUE
      END IF
c     rotation:
c     call drotg(nz,xgwork,1,ygwork,1,COS(ALPHA),SIN(ALPHA))
c     loop over all tiles and pass them into KRIGE:
      DO 20 I=1,NTX
         DO 10 J=1,NTY
c           determine tile corners:            
            IL=(I-1)*ITX+1
            IU=MIN(I*ITX,NX)
            JL=(J-1)*ITY+1
            JU=MIN(J*ITY,NY)
            LIPT=(IU-IL+1)*(JU-JL+1)
c           fill work arrays with current tile data:  

            CALL DSUBMV(XGWORK,NX,NY,IL,JL,IU,JU,NX,X0,1)
            CALL DSUBMV(YGWORK,NX,NY,IL,JL,IU,JU,NX,Y0,1)
            CALL ISUBMV(DOG,NX,NY,IL,JL,IU,JU,NX,DO0,1)

            name="x0"
            call matpr(x0,lipt,1,ipt,name,dbglvl)
            name="y0"
            call matpr(y0,lipt,1,ipt,name,dbglvl)

c           the main work now is done be KRIGE:
            CALL BK(X0,Y0,DO0,INDDO,LIPT,LON,LAT,Z,N,
     .                 COVTYPE,COVPAR,COVMAT,C0,COV0,TREND,
     .                 NTREND,RSEARCH,NSEARCH,NSMIN,NSMAX,FWORK,FWRK2,
     .                 F0WORK,
     .                 DIST,INDSNB,INDSNA,INDSRT,KWORK,NKWORK,RHSWORK,
     .                 IPIV,MODE,MU,Z0,LAMBDA,VAR0,IERR)

            name="xg"
            call matpr(xg,nx,1,nx,name,dbglvl)
            name="yg"
            call matpr(yg,ny,1,ny,name,dbglvl)
c           extract results for this tile
            CALL DSUBMV(ZG,NX,NX,IL,JL,IU,JU,NX,Z0,-1)
            CALL DSUBMV(VARG,NX,NY,IL,JL,IU,JU,NX,VAR0,-1)
 10      CONTINUE
 20   CONTINUE


      RETURN
      END


