
check.searchparams <- function(maxdist,rsearch,nsearch,nsmin,nsmax,n){
    if(!is.null(maxdist) && is.null(rsaerch))
        rsearch<-maxdist
    if(rsearch>0 & nsearch>0)
        stop("specify only one of rsearch and nsearch\n")
    if(nsmin>nsmax)
        stop("nsmin>nsmax\n")
    if(nsmin<0)
        nsmin<-0
    if(nsmax<0)
        nsmax<-n
    if(nsearch<0)
        stop("nsearch negative!\n")
    list(rsearch=rsearch,nsmin=nsmin,nsmax=nsmax)
}

check.krigedata <- function(point.obj,at,var.mod.obj,mode){
    at <- point.obj[[match(at, names(point.obj))]]
    n <- length(point.obj$x)
    if (!inherits(point.obj, "point")) 
      stop("point.obj must be of class, \"point\".\n")
    if (!inherits(var.mod.obj, "variogram.model")) 
      stop("var.mod.obj must be of class, \"variogram.model\".\n")
    if(mode==1 && length(at)!=n) stop("length of x and z differ\n")
    list(n=n)
}


remove.duplicates <- function(point.obj,at,
                              duplicate,dupfun) {
# eliminate duplicates:
    xy <- paste(point.obj$x, point.obj$y, sep =",")
    idup <- match(xy, xy)
    if(duplicate=="user" && !is.function(dupfun))
      stop("duplicate=\"user\" requires dupfun to be set to a function")
    if(duplicate!="error")
      {
        centre <- function(x) {
          switch(duplicate,
                 mean = mean(x),
                 median = median(x),
                 user = dupfun(x))
        }
        if(duplicate!="strip"){
          point.obj[[match(at, names(point.obj))]] <- unlist(lapply(split(point.obj[[match(at, names(point.obj))]],idup), centre))
          ord <- !duplicated(xy)
          point.obj$x <- point.obj$x[ord]
          point.obj$y <- point.obj$y[ord]
          n <- length(point.obj$x)
        }
      else{
        ord <- (hist(idup,plot=F,freq=T,breaks=seq(0.5,max(idup)+0.5,1))$counts==1)
        point.obj$x <- point.obj$x[ord]
        point.obj$y <- point.obj$y[ord]
        point.obj[[match(at, names(point.obj))]] <- point.obj[[match(at, names(point.obj))]][ord]
        n <- length(point.obj$x)
      }
      }
    else
      if(any(duplicated(xy)))
        stop("duplicate data points")
  point.obj
}

matlist.cbind<-function(lst){
# cbind a list of matrices
    nmat<-length(lst); ret<-NULL;
#    mdim<-dim(lst[[1]])
    for(i in 1:nmat) {
#        if(dim(lst[[i]])[[1]]!=mdim[[1]] && dim(lst[[i]])[[2]]!=mdim[[2]])
#            stop('matrix dimensions not conform in matlist.cbind')
        ret<-cbind(ret,lst[[i]])
    }
    ret
}


    
check.gridparams<-function(angle,xsw,xne,ysw,yne,
                           dx,dy,nx,ny){
    if(is.null(angle)) angle <- 0
    
    if(is.null(xsw)) xsw <- min(point.obj$x)
    if(is.null(xne)) xne <- max(point.obj$x)
    if(is.null(ysw)) ysw <- min(point.obj$y)
    if(is.null(yne)) yne <- max(point.obj$y)
    
    dgx <- xne-xsw
    dgy <- yne-ysw
    
    if(is.null(nx)){
        if(is.null(dx)) dx <- dgx/20
        
        nx <- ceiling(dgx/dx)+1
    } else {
        if(!is.null(dx))
            stop("either \"dx\" or \"nx\" should be given!")
        if(nx==0)
            stop("\"dx\" cannot be 0!")
        
        dx <- dgx/nx
        
    }
    if(is.null(ny)){
        if(is.null(dy)) dy <- dgy/20
        
        ny <- ceiling(dgy/dy)+1
    } else {
        if(!is.null(dy))
            stop("either \"dy\" or \"ny\" should be given!")
        if(ny==0)
            stop("\"dy\" cannot be 0!")
      
        dy <- dgy/ny
        
    }
    nz <- nx * ny
    list(nz=nz,nx=nx,ny=ny,dx=dx,dy=dy,
         xsw=xsw,xne=xne,ysw=ysw,yne=yne)
}

check.border.grid<-function(extrap,xsw,xne,ysw,yne,nx,ny,border,point.obj){
    dog <- matrix(1, nx, ny)
    if (!extrap) {
        tmpgrd <- cbind(rep(seq(xsw,xne,length=nx),ny),sort(rep(seq(ysw,yne,length=ny),nx)))
        if(is.null(border))
            dog <- in.chull(tmpgrd[,1], tmpgrd[,2],point.obj$x,point.obj$y)
        else {
            if(is.null(border$x) | is.null(border$y) | length(border$x)!=length(border$y))
                stop("border argument wrong!")
            dog <- in.polygon(tmpgrd[,1], tmpgrd[,2], border$x,border$y)
        }
# workaround for int <-> unsigned int problem on alpha platform:
        dog <- abs(as.numeric(dog))
        dog <- matrix(dog, nx, ny,byrow=F)
    }
    dog
}

check.border.points<-function(extrap,x,y,npts,border,point.obj){
    dopts<-rep(1,length=npts)
    if (!extrap) {
      if(is.null(border))
        dopts <- in.chull(x,y,point.obj$x,point.obj$y)
      else {
        if(is.null(border$x) | is.null(border$y) | length(border$x)!=length(border$y))
          stop("border argument wrong!")
        dopts <- in.polygon(x,y, border$x,border$y)
      }
      # workaround for int <-> unsigned int problem on alpha platform:
      dopts <- abs(as.numeric(dopts))
    }
    dopts
}

