###--- >>> `earliest.end' <<<----- Start and End for Multiple Time Series Objects

	## alias	 help(earliest.end)
	## alias	 help(earliest.end.index)
	## alias	 help(earliest.end.index.tframe)
	## alias	 help(earliest.end.index.tframe.default)
	## alias	 help(earliest.end.index.tframe.tstframe)
	## alias	 help(earliest.end.tframe)
	## alias	 help(earliest.start)
	## alias	 help(earliest.start.index)
	## alias	 help(earliest.start.index.tframe)
	## alias	 help(earliest.start.index.tframe.default)
	## alias	 help(earliest.start.index.tframe.tstframe)
	## alias	 help(earliest.start.tframe)
	## alias	 help(latest.end)
	## alias	 help(latest.end.index)
	## alias	 help(latest.end.index.tframe)
	## alias	 help(latest.end.index.tframe.default)
	## alias	 help(latest.end.index.tframe.tstframe)
	## alias	 help(latest.end.tframe)
	## alias	 help(latest.start)
	## alias	 help(latest.start.index)
	## alias	 help(latest.start.index.tframe)
	## alias	 help(latest.start.index.tframe.default)
	## alias	 help(latest.start.index.tframe.tstframe)
	## alias	 help(latest.start.tframe)

##___ Examples ___:

    t1<-ts(c(1,2,3,4,5), start=c(1991,1))
    t2<-ts(c(2,3,4,5,6,7,8), start=c(1992,1))
    t3<-ts(c(NA,2,3,4,5), start=c(1991,1))

    latest.start(t1,t2,t3)  # 1992 1 corresponding to the starting date of 
                            # the object which starts latest (t2)
    latest.start(t1,t3)     # both start in 1991 1 (NAs count as data)
    latest.start(tbind(t1,t2,t3)) # tbind gives a single object starting in 1991 1
    latest.start(t2, tbind(t1,t2,t3))

    latest.start.index(t1,t2,t3)  # position of t2 in the argument list

## Keywords: 'programming', 'utilities', 'ts', 'chron'.


