###--- >>> `plot.bbnam' <<<----- Plotting for bbnam Objects

	## alias	 help(plot.bbnam)
	## alias	 help(plot.bbnam.fixed)
	## alias	 help(plot.bbnam.pooled)
	## alias	 help(plot.bbnam.actor)

##___ Examples ___:

#Create some random data
g<-rgraph(5)
g.p<-0.8*g+0.2*(1-g)
dat<-rgraph(5,5,tprob=g.p)

#Define a network prior
pnet<-matrix(ncol=5,nrow=5)
pnet[,]<-0.5
#Define em and ep priors
pem<-matrix(nrow=5,ncol=2)
pem[,1]<-3
pem[,2]<-5
pep<-matrix(nrow=5,ncol=2)
pep[,1]<-3
pep[,2]<-5

#Draw from the posterior
b<-bbnam(dat,model="actor",nprior=pnet,emprior=pem,epprior=pep,
    burntime=100,draws=100)
#Print a summary of the posterior draws
summary(b)
#Plot the result
plot(b)

## Keywords: 'hplot', 'network'.


