###--- >>> `gscov' <<<----- Find the Structural Covariance(s) Between Two or More Graphs

	## alias	 help(gscov)

##___ Examples ___:

#Generate two random graphs
g.1<-rgraph(5)
g.2<-rgraph(5)

#Copy one of the graphs and permute it
perm<-sample(1:5)
g.3<-g.2[perm,perm]

#What are the structural covariances between the labeled graphs?
gscov(g.1,g.2,exchange.list=1:5)
gscov(g.1,g.3,exchange.list=1:5)
gscov(g.2,g.3,exchange.list=1:5)

#What are the structural covariances between the underlying 
#unlabeled graphs?
gscov(g.1,g.2)
gscov(g.1,g.3)
gscov(g.2,g.3)

## Keywords: 'univar', 'multivariate', 'network'.


