###--- >>> `ms.nprev' <<<----- Logistic regression of two-stage data using second stage sample and first stage sample sizes or proportions (prevalences) as input

	## alias	 help(ms.nprev)

##___ Examples ___:


##Don't run: As an illustrative example, we use a simulated data set, simNA.
##D Use 

data(simNA)        #to load the data
##Don't run: and
help(simNA)        #for details


##Don't run: The "complete cases" (i.e. second-stage data) can be extracted by:

complete_simNA[!is.na(simNA[,3]),]

##Don't run: Running a logistic regression analysis on the complete data:

summary(glm(complete[,1]~complete[,3], family="binomial"))


##Don't run: gives the following result
##D 
##D Call:
##D glm(formula = complete[, 1] ~ complete[, 3], family = "binomial")
##D 
##D Coefficients:
##D               Estimate Std. Error z value Pr(>|z|)    
##D (Intercept)    0.05258    0.09879   0.532    0.595    
##D complete[, 3]  1.01942    0.12050   8.460   <2e-16 ***


##Don't run: The first and second stage sample sizes can be viewed by running
##D the "coding" function (see help(coding) for details)


coding(x=simNA[,3], y=simNA[,1], z=simNA[,2])
##Don't run: which gives the following:
##D 
##D  [1] "For calls to ms.nprev, input n1 or prev in the following order!!"
##D      ylevel z new.z  n1  n2
##D [1,]      0 0     0 310 150
##D [2,]      0 1     1 166  85
##D [3,]      1 0     0 177  86
##D [4,]      1 1     1 347 179


##Don't run: An analysis of all first- and second-stage data using Mean Score:

# supply the first stage sample sizes in the correct order
n1_c(310,166,177,347)
ms.nprev(x=complete[,3],z=complete[,2],y=complete[,1],n1=n1)

##Don't run: gives the results:
##D [1] "please run coding function to see the order in which you"
##D [1] "must supply the first-stage sample sizes or prevalences"
##D [1] " Type ?coding for details!"
##D [1] "For calls to ms.nprev,input n1 or prev in the following order!!"
##D      ylevel z new.z  n2
##D [1,]      0 0     0 150
##D [2,]      0 1     1  85
##D [3,]      1 0     0  86
##D [4,]      1 1     1 179
##D [1] "Check sample sizes/prevalences"
##D $table
##D      ylevel zlevel  n1  n2
##D [1,]      0      0 310 150
##D [2,]      0      1 166  85
##D [3,]      1      0 177  86
##D [4,]      1      1 347 179
##D 
##D $parameters
##D                   est         se          z    pvalue
##D (Intercept) 0.0493998 0.07155138  0.6904103 0.4899362
##D x           1.0188437 0.10187094 10.0013188 0.0000000


##Don't run: If we supply the prevalances instead of first stage sample sizes
p1_c(310,166,177,347)/1000
ms.nprev(x=complete[,3],z=complete[,2],y=complete[,1],prev=p1)

##Don't run: we get the output:
##D 
##D       ylevel zlevel  prev  n2
##D [1,]      0      0 0.310 150
##D [2,]      0      1 0.166  85
##D [3,]      1      0 0.177  86
##D [4,]      1      1 0.347 179
##D 
##D $parameters
##D                    est
##D (Intercept) 0.04939797
##D x           1.01885599



##Don't run: Note that the Mean Score algorithm produces smaller 
##D standard errors of estimates than the complete-case
##D analysis, due to the additional information in the
##D incomplete cases.

## Keywords: 'regression'.


