###--- >>> `event.chart' <<<----- Very flexible event chart for Time-to-Event Data

	## alias	 help(event.chart)

##___ Examples ___:

data(shin)
shin<-as.matrix(shin)

##Data were extracted from Shin D.M., Lee, J.S., Lippman, S.M., Lee, J.J.,
##Tu, Z.N.,Choi, G., Heyne, K., Shin, H.J.,C., Ro, J.Y., Goepfert, H., Hong, W. K.,
##and Hittelman, W. N. (1996), "p53 Expression: Predicting Recurrence and
##Second  Primary Tumors in Head and Neck Squamous Cell Carcinoma,
##" Journal of National  Cancer Institute, 88, 519-529.

##id denotes subject ID
##age denotes the age of the subject
##p53 denotes the status of the covariate p53: 0=negative; 1=positive
##stage denotes the stage
##datened denotes the registration at NED = no evidence of disease
##daterec denotes the recurrence data
##datespt denote the time of the second primary tumor
##datedead denotes the time of the death
##datelfu denotes the time od the last follow-up

##we got the others columns in the following way:
##ind.dead <- !is.na(datedead)
##date.last.seen <- rep(NA,20)
##date.last.seen[ind.dead] <- datedead[ind.dead]
##date.last.seen[!ind.dead] <- datelfu[!ind.dead]
##date.last.seen = date.last.seen
##fu = date.last.seen - datened
##rec = daterec - datened
##spt = datespt - datened
##p53.time =100000 * (1-p53) + (date.last.seen - datened)
##p53.rec =100000 * (1-p53) + rec
##p53.spt = 100000 * (1-p53) + spt

##to produce simple Calendar Event Chart.

event.chart(shin,subset.c=c(5,6,7,8,9),
 y.idlabels=1,
 x.julian=FALSE,date.orig=c(month=1, day=1, year=1960),
 point.cex=c(.6,.8,.6,.8,.8),point.pch=c(1,17,16,4,0),point.col=rep(1,5),
 line.lwd=1,x.lab='Calendar Date',y.lab='Patient ID',
 titl="Calendar Event Chart",cex=.95,las=1,
 omi=c(2,0,1,.2),mai=c(.7,.7,.4,.07), mgp=c(2,.5,0), cex=.8)

legend(7900,.5,pch=c(1,17,16,4,0),c("date of registration","date of recurrence",
"date of SPT","date of death","date last follow-up"),ncol=5,cex=.8)

##to produce simple interval Event Chart,
event.chart(shin,subset.c=c(5,6,7,8,9), x.reference=5,
 y.idlabels=1, x.julian=TRUE, x.scale=365,
 point.cex=c(.6,.8,.6,.8,.8),point.pch=c(1,17,16,4,0),point.col=rep(1,5),
 line.lwd=1,x.lab='Years From No Evidence of Disease',
 y.lab='Patient ID',titl="Interval Event Chart",
 y.axis='custom',y.axis.custom.at=1:20,y.axis.custom.label=1:20,
 omi=c(2,0,1,.2),mai=c(.7,.7,.4,.07), mgp=c(2,.5,0), cex=.75)

legend(1.2,.2,pch=c(1,17,16,4,0),c("date of registration","date of recurrence",
"date of SPT","date of death","date last follow-up"),ncol=5, cex=.8)

##to produce Goldman Event Chart

event.chart(shin,subset.c=c(5,6,7,8,9), x.reference=5,
 x.julian=TRUE, x.scale=365, y.var=5, now.line=TRUE, y.var.type='d',
 point.cex=c(.6,.8,.6,.8,.8),point.pch=c(1,17,16,4,0),point.col=rep(1,5),
 line.lwd=1,x.lab='Years From No Evidence of Disease',
 y.lab='Calendar Date of NED',titl="Goldman Event Chart", adj=0.5,
 omi=c(2,0,1,.2), mai=c(.7,.7,.4,.07), mgp=c(2,.5,0), cex=.75)

legend(1.2,7340,pch=c(1,17,16,4,0),c("date of registration","date of recurrence",
"date of SPT","date of death","date last follow-up"),ncol=5, cex=.75)

##(a) to produce Calendar Event Chart by last F/U

event.chart(shin,subset.c=c(5,6,7,8,9), sort.ascending=FALSE,
 y.idlabels=1,legend.plot=FALSE,
 x.julian=FALSE,date.orig=c(month=1, day=1, year=1960),
 point.cex=c(.6,.8,.6,.8,.8),point.pch=c(1,17,16,4,0),point.col=rep(1,5),
 line.lwd=1,x.lab='Calendar Date',y.lab='Patient ID',
 titl=" (a) Calendar EC by Last F/U",las=1,
 omi=c(1,0,1,.2),mai=c(.6,.7,.4,.1), mgp=c(2,.5,0), cex=.8,
 sort.by=10, x.axis='custom',
 x.axis.custom.at=c(julian(1,1,1980), julian(1,1,1985), julian(1,1,1990),
 julian(1,1,1995)),x.axis.custom.labels=c("1/1/80","1/1/85","1/1/90","1/1/95"),
 x.lim.extend=c(0,450))

par(omi=c(1,0,1,.2),mai=c(.6,.7,.4,.1), mgp=c(2,.5,0))
abline(v=c(julian(1,1,1985),julian(1,1,1990)),lty=2,col=2,lwd=.1)

par(omi=c(0,0,0,0))
mtext(side=3,"Sorting and Alignment Extensions of Event Charts (EC)",line=-2)

## (b) to produce Interval Event Chart by F/U time

event.chart(shin,subset.c=c(5,6,7,8,9), x.reference=5, sort.ascending=FALSE,
 x.julian=TRUE, x.scale=365, y.idlabels=1,
 point.cex=c(.6,.8,.6,.8,.8),point.pch=c(1,17,16,4,0),point.col=rep(1,5),
 line.lwd=1,x.lab='Years From No Evidence of Disease',
 y.lab='Patient ID',titl=" (b) Interval EC by F/U Time",
 y.axis='custom',y.axis.custom.at=1:20,y.axis.custom.label=1:20,
 omi=c(.5,0,1,.2),mai=c(.6,.7,.4,.1), mgp=c(2,.5,0), cex=.7,
 sort.by=11)

par(omi=c(.5,0,1,.2),mai=c(.6,.7,.4,.1), mgp=c(2,.5,0))
abline(v=c(julian(1,27,1986)-julian(5,29,1981),
 julian(2,8,1991)-julian(8,21,1981))/365,lty=2,col=2,lwd=.1)

##(c) to produce Event Chart by time of recurrence

event.chart(shin,subset.c=c(5,6,7,8,9),x.reference=6,NA.rm=TRUE,sort.ascending=FALSE,
 x.julian=TRUE, x.scale=365, y.idlabels=1,
 point.cex=c(.6,.8,.6,.8,.8),point.pch=c(1,17,16,4,0),point.col=rep(1,5),
 line.lwd=1,x.lab='Years From Recurrence',
 y.lab='Patient ID',titl="(c) EC by Time to Recurrence",
 y.axis='custom',y.axis.custom.at=1:20,y.axis.custom.label=1:20,
 omi=c(1.8,0,.8,.2), mai=c(.4,.9,.3,.1), mgp=c(2,.4,0), cex=.7,
 sort.by=12)

## (d) to produce Event Chart by time to SPT

event.chart(shin,subset.c=c(5,6,7,8,9),x.reference=7,NA.rm=TRUE,sort.ascending=FALSE,
 x.julian=TRUE, x.scale=365, y.idlabels=1,
 point.cex=c(.6,.8,.6,.8,.8),point.pch=c(1,17,16,4,0),point.col=rep(1,5),
 line.lwd=1,x.lab='Years From SPT',
 y.lab='Patient ID',titl="(d) EC by Time to SPT",
 y.axis='custom',y.axis.custom.at=1:20,y.axis.custom.label=1:20,
 omi=c(1.5,0,.7,.2), mai=c(.6,.9,.6,.1), mgp=c(2,.4,0), cex=.7,
 sort.by=13)

## (a) to produce Event Chart p53 and On-Study time

event.chart(shin,subset.c=c(5,6,7,8,9), x.reference=5, sort.ascending=FALSE,
 x.julian=TRUE, x.scale=365, y.idlabels=1,
 point.cex=c(.6,.8,.6,.8,.8),point.pch=c(1,17,16,4,0),point.col=rep(1,5),
 x.lab='Years From No Evidence of Disease',
 y.lab='Patient ID',titl="(a) EC by p53 & On-Study Time",
 omi=c(1.5,0,.7,.2),mai=c(.6,.9,.6,.1), mgp=c(2,.4,0), cex=.65,
 sort.by=14, line.by=3, line.lty=c(2,1), line.lwd=c(1,1), line.col=c(1,1))

par(omi=c(0,0,0,0))
mtext(side=3,"Extensions of Event Charts for Showing the Covariate Effect:",Line=4)

## (b) to produce Event Chart by p53 and time to recur

event.chart(shin,subset.c=c(5,6,7,8,9), x.reference=6, NA.rm=TRUE, sort.ascending=FALSE,
 x.julian=TRUE, x.scale=365, y.idlabels=1,
 point.cex=c(.6,.8,.6,.8,.8),point.pch=c(1,17,16,4,0),point.col=rep(1,5),
 x.lab='Years From Recurrence',
 y.lab='Patient ID',titl="(b) EC by p53 & Time to Recur",
 omi=c(1.8,0,.8,.2), mai=c(.4,.9,.3,.1), mgp=c(2,.4,0), cex=.65,
 sort.by=15, line.by=3, line.lty=c(2,1), line.lwd=c(1,1), line.col=c(1,1))

## (c) to produce Event Chart by p53 and time to SPT

event.chart(shin,subset.c=c(5,6,7,8,9), x.reference=7, NA.rm=TRUE, sort.ascending=FALSE,
 x.julian=TRUE, x.scale=365, y.idlabels=1,
 point.cex=c(.6,.8,.6,.8,.8),point.pch=c(1,17,16,4,0),point.col=rep(1,5),
 x.lab='Years From SPT',
 y.lab='Patient ID',titl="(c) EC by p53 & Time to SPT",
 omi=c(2,0,1,.2), mai=c(.6,.7,.4,.1), mgp=c(2,.4,0), cex=.65,
 sort.by=16, line.by=3, line.lty=c(2,1), line.lwd=c(1,1), line.col=c(1,1))

##(d) to produce Event Chart by age coded by p53. Solid line
##for p53(+) cases and dashed line for p53(-)cases

set.seed(1993)
event.chart(shin,subset.c=c(5,6,7,8,9), x.reference=5, sort.ascending=FALSE,
 x.julian=TRUE, x.scale=365, y.var=2, y.jitter=TRUE,
 point.cex=c(.6,.8,.6,.8,.8),point.pch=c(1,17,16,4,0),point.col=rep(1,5),
 x.lab='Years From No Evidence of Disease',
 y.lab='Age',titl="(d) EC by Age coded by p53",y.lim.extend=c(2,3),
 y.axis='custom', y.axis.custom.at=c(40,50,60,70,80),
 y.axis.custom.label=c(40,50,60,70,80),omi=c(1,0,1,.2),mai=c(.2,.7,.4,.1),
 mgp=c(2,.5,0), cex=.65,line.by=3, line.lty=c(2,1), line.lwd=c(1,1),
 line.col=c(1,1))

par(omi=c(0.2,0,1,.2))
mtext(side=1,"Solid Line for p53(+) Cases and Dashed Line for p53(-) Cases",
line=3)


## Keywords: 'event.chart,hplot,chron'.


